#include "mbed.h"
#include "ST7735_TFT.h"
#include "Arial24x23i.h"
#include "Arial11x11.h"
#include "Arial9x9.h"
#include "MPU6050.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Serial pc(USBTX, USBRX); // tx, rx default baud rate: 9600
 
void compFilter();
void preparePeriferals();

MPU6050 mpu6050;           // class: MPU6050, object: mpu6050 
PinName const SDA = PTE25;
PinName const SCL = PTE24;
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); //on-board accelerometer
//ST7735_TFT lcd(PTD6, NC, PTD5, PTA13, PTD2, PTD4, "TFT"); // TFT; sda, miso (not connected), sck, cs, AO(rs), reset
Ticker systick; 

float pitchAngle = 0;
float rollAngle = 0;
float rollX = 0;
float pitchY = 0;
int main()
{   
    
    pc.baud(9600);                              // baud rate: 9600
    mpu6050.whoAmI();                           // Communication test: WHO_AM_I register reading 
    wait(1);
    mpu6050.calibrate(accelBias,gyroBias);      // Calibrate MPU6050 and load biases into bias registers
    pc.printf("Calibration is completed. \r\n");
    wait(0.5);
    mpu6050.init();                             // Initialize the sensor
    wait(1);
    pc.printf("MPU6050 is initialized for operation.. \r\n\r\n");
    wait_ms(500);
    systick.attach(&compFilter, 0.005);    // calls the complementaryFilter func. every 5 ms (200 Hz sampling period)             
    while (true) 
    {
        atan (ax);
        //pc.printf("Accelerometer (onboard)   X = %1.2f, Y = %1.2f, Z = %1.2f\r\n", acc.getAccX(), acc.getAccY(), acc.getAccZ());
        pc.printf("Accelerometer MPU6050(g)  X = %.3f,  Y = %.3f,  Z = %.3f\r\n", ax, ay, az);
        pc.printf("Gyroscope MPU6050(deg/s) gx = %.3f, gy = %.3f,  gz = %.3f\r\n", gx, gy, gz);
        pc.printf("Gyroscope MPU6050(deg/s) roll = %.3f, pitch = %.3f\r\n",rollAngle, pitchAngle);
        wait(1.0f);     
                                                               
    }    
}
void compFilter() {
    mpu6050.complementaryFilter(&pitchAngle, &rollAngle);
}
