#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Serial pc(USBTX, USBRX); // tx, rx
MMA8451Q acc(PTE25,PTE24,MMA8451_I2C_ADDRESS);
TSISensor tsi;

char c;

void Actividad_1();
void Actividad_2();
void Actividad_3();

void leercaracter();
    
void colorear(int A, int B, int C);

float V;

float X, Y, Z;

PwmOut REDLED(LED1);
PwmOut GREENLED(LED2);
PwmOut BLUELED(LED3);
    
int main() {
    while(1) {
        pc.printf("%d\n",pc.readable());
        pc.printf("Ingrese numero se actividad\n1.Secuencia de colores\n2.Touch\n3.Acelerometro\n");
        leercaracter();
        if(c == '1'){
            Actividad_1();
            }
        else if(c == '2'){
            Actividad_2();
            }
        else if(c == '3'){
            Actividad_3();
            }
        else{
            pc.printf("Error - Actividad no definida\n");
        }
    }
}

void Actividad_1() {
    pc.printf("Ejecutando Actividad_1\n");
    pc.printf("Ingrese numero se actividad\n1.Secuencia de colores\n2.Touch\n3.Acelerometro\n");
    while(1) {
        colorear(0,1,1);
        if(pc.readable()){
            leercaracter();
            break;
        }
        colorear(1,0,1);
        if(pc.readable()){
            leercaracter();
            break;
        }
        colorear(1,1,0);
        if(pc.readable()){
            leercaracter();
            break;
        }
        colorear(0,0,1);
        if(pc.readable()){
            leercaracter();
            break;
        }
        colorear(0,1,0);
        if(pc.readable()){
            leercaracter();
            break;
        }
        colorear(1,0,0);
        if(pc.readable()){
            leercaracter();
            break;
        }
        colorear(0,0,0);
        if(pc.readable()){
            leercaracter();
            break;
        }
    }
}

void colorear(int A, int B, int C)
{
    REDLED = A;
    GREENLED = B;
    BLUELED = C;
    wait(1);
}

void Actividad_2() {
    pc.printf("Ejecutando Actividad_2\n");
    pc.printf("Ingrese numero se actividad\n1.Secuencia de colores\n2.Touch\n3.Acelerometro\n");
    while(true) {
        V=tsi.readPercentage();
        pc.printf("%f\n",V);
        REDLED=1.0-V;
        GREENLED=1.0-V;
        BLUELED=1.0-V;
        wait(0.01);
        if(pc.readable()){
            leercaracter();
            break;
        }
    }
}

void Actividad_3() {
    pc.printf("Ejecutando Actividad_3\n");
    pc.printf("Ingrese numero se actividad\n1.Secuencia de colores\n2.Touch\n3.Acelerometro\n");
    while(true) {
        X=abs(acc.getAccX());
        Y=abs(acc.getAccY());
        Z=abs(acc.getAccZ());
        pc.printf("X=%0.2f\tY=%0.2f\tZ=%0.2f\n",X,Y,Z);
        REDLED= 1.0 - X;
        GREENLED = 1.0 - Y;
        BLUELED = 1.0 - Z;
        wait(0.1);
        if(pc.readable()){
            leercaracter();
            break;
        }
    }
}

void leercaracter(){
    c = pc.getc();
    /*while (pc.readable()){
        pc.getc();
    }*/
}