#ifndef RFID_125KHZ_GROVE_H
#define RFID_125KHZ_GROVE_H

#include "mbed.h"

/** 
  * Provides full Library for Grove RFID scanner 
  * http://www.seeedstudio.com/wiki/Grove_-_125KHz_RFID_Reader
  *
  */

class RfidGrove
{
public:
/**
  * RfidGrove constructor
  *
  * @param tx TX pin
  * @param rx RX pin
  * @param buff0 - char[64] work buffer
  * @param bufflen -  work buffer length
  */
    RfidGrove(PinName tx, PinName rx , char* buff0, int bufflen );

/**
  * RfidGrove destructor
  */
    ~RfidGrove();
    
    int Available();
    
    void ClearBuffer();
    
    int GetCharCount();


private:
    Serial _rfid;
    Timer _t;
    int _available;
    int _waittime;
    char * _buff;
    int _bufferlen;
    int _cnt;
    
    void Callback();
};

#endif

/*
  //Example of use:
  
#include "mbed.h"
#include "RFID_125KHz_Grove.h"



string ss;
char buff[64];

RfidGrove rfid(PA_11, PA_12, buff, 64);
Serial pc (USBTX,USBRX);

int main()
{
    pc.baud(9600);
    pc.printf("RFID TEST \n");      
    
    while(1) {
        if( rfid.Available()) {
            pc.printf("|>%s< (%d char)| " ,buff,rfid.GetCharCount());
        }
    }
}
*/