#include "RFID_125KHz_Grove.h"

Serial pc1 (USBTX,USBRX);
//Constructor
RfidGrove::RfidGrove(PinName tx, PinName rx , char* buff0, int bufflen ) :
    _rfid(tx, rx),
    
    _available (0),
    _waittime (300),
    _cnt (0),
    _bufferlen (bufflen)
    
    
{
    _buff = buff0;
    _t.reset();
    _t.start();
    ClearBuffer();
    _rfid.attach   ( this ,&RfidGrove::Callback );


}

//Destructor
RfidGrove::~RfidGrove() { }

void RfidGrove::ClearBuffer()
{
    _t.reset();
    _t.start();
    _available = 0;
    for (int i=0; i< _bufferlen ; i++ )
    {
        _buff[i] = 0;
    }   
    _cnt = 0;
}

int RfidGrove::Available()
{
    if ( _available == 1 && ( _t.read_ms() > _waittime || _t.read_ms() < 0 ) )
    {
        return 1;
    }
    return 0;
}

int RfidGrove::GetCharCount()
{
    return _cnt;
}

void RfidGrove::Callback()
{
    char c = _rfid.getc();
    _available = 1;
    
    if ( _cnt < _bufferlen  && c != 2 && c != 3 )
    {
        _buff[_cnt++] = c;
    }
}