#include "CmdUplinkCounter.h"

CmdUplinkCounter::CmdUplinkCounter(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Uplink Counter", "AT+ULC", "Get or set the uplink counter for the next packet"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-4294967295)";
    _queryable = true;
}

uint32_t CmdUplinkCounter::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Uplink Counter: ");

        _serial.writef("%u\r\n", _dot->getUpLinkCounter());
    } else if (args.size() == 2) {
        int32_t code;
        int count;
        sscanf(args[1].c_str(), "%d", &count);

        if ((code = _dot->setUpLinkCounter(count)) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }
    return 0;
}

bool CmdUplinkCounter::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        int count;
        if (sscanf(args[1].c_str(), "%d", &count) == 1) {
            if (count > 4294967295) {
                setErrorMessage("Invalid uplink counter, expects (0-4294967295)");
                return false;
            }
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}

