#include "CmdSerialBaudRate.h"

CmdSerialBaudRate::CmdSerialBaudRate(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Serial Baud Rate", "AT+IPR", "Set serial baud rate, default: 115200 "), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1200,2400,4800,9600,19200,38400,57600,115200,230400,460800,921600)";
    _queryable = true;
}

uint32_t CmdSerialBaudRate::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Serial Baud Rate: ");

        _serial.writef("%lu\r\n", _dot->getBaud());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int baudrate = 0;

        sscanf(args[1].c_str(), "%d", &baudrate);

        if ((code = _dot->setBaud(baudrate)) == mDot::MDOT_OK) {
            _serial.writef("Set Serial Baud Rate: %lu\r\n", baudrate);
        } else {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdSerialBaudRate::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        int baudrate;

        if (sscanf(args[1].c_str(), "%d", &baudrate) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
