#include "CmdResetCpu.h"

CmdResetCpu::CmdResetCpu(mDot* dot, mts::MTSSerial& serial) : Command(dot, "Reset CPU", "ATZ", "Reset the CPU"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
}

uint32_t CmdResetCpu::action(std::vector<std::string> args) 
{
    _serial.writef("\r\nOK\r\n");
    wait(0.5);
    HAL_NVIC_SystemReset();
    return 0; 
}

