/*
 * CmdPreserveSession.cpp
 *
 *  Created on: Nov 4, 2015
 *      Author: jreiss
 */

#include "CmdPreserveSession.h"

CmdPreserveSession::CmdPreserveSession(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Preserve Session", "AT+PS", "Save network session info through reset or power down in AUTO_OTA mode (0:off, 1:on)"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

CmdPreserveSession::~CmdPreserveSession()
{
    // TODO Auto-generated destructor stub
}

uint32_t CmdPreserveSession::action(std::vector<std::string> args) {

    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Preserve Session: ");

        _serial.writef("%u\r\n", _dot->getPreserveSession());
    } else {
        _dot->setPreserveSession(args[1] == "1");
    }

    return mDot::MDOT_OK;
}

bool CmdPreserveSession::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        if (args[1] != "1" && args[1] != "0") {
            setErrorMessage("Invalid parameter, expects (0: off, 1: on)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
