#include "CmdWakeDelay.h"

CmdWakeDelay::CmdWakeDelay(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Wake Delay", "AT+WD", "Time to wait for data after wakeup signal  (milliseconds)"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(2-2147483647) ms";
    _queryable = true;
}

uint32_t CmdWakeDelay::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getWakeDelay());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int delay;
        sscanf(args[1].c_str(), "%d", &delay);

        if ((code = _dot->setWakeDelay(delay)) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdWakeDelay::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int delay;
        if (sscanf(args[1].c_str(), "%d", &delay) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (delay < 2 || delay > INT_MAX) {
            setErrorMessage("Invalid delay, expects (2-2147483647) ms");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
