#include "CmdTxNextMs.h"

CmdTxNextMs::CmdTxNextMs(mDot* dot, mts::MTSSerial& serial)
: Command(dot, "Tx Next", "AT+TXN", "Get time in ms until next free channel"), _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-2793000)";
    _queryable = true;
}

uint32_t CmdTxNextMs::action(std::vector<std::string> args) {

    if (_dot->getVerbose())
        _serial.writef("Next Tx in: ");

    _serial.writef("%lu\r\n", _dot->getNextTxMs());

    return 0;
}

bool CmdTxNextMs::verify(std::vector<std::string> args) {

    if (args.size() > 1)
        return false;

    return true;
}
