/*
 * CmdRxDelay.cpp
 *
 *  Created on: Nov 4, 2015
 *      Author: jreiss
 */

#include "CmdRxDelay.h"

CmdRxDelay::CmdRxDelay(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Rx Delay", "AT+RXD", "Number of seconds before receive windows are opened (1 - 15)"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1-15)";
    _queryable = true;
}

CmdRxDelay::~CmdRxDelay()
{
    // TODO Auto-generated destructor stub
}

uint32_t CmdRxDelay::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Rx Delay: ");

        _serial.writef("%u\r\n", _dot->getRxDelay());
    } else if (args.size() == 2) {
        int32_t code;
        int rxDelay;
        sscanf(args[1].c_str(), "%d", &rxDelay);

        if ((code = _dot->setRxDelay(rxDelay)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }
    return 0;
}

bool CmdRxDelay::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        int rxDelay;
        if (sscanf(args[1].c_str(), "%d", &rxDelay) == 1) {

            if (rxDelay > 15 || rxDelay < 1) {
                setErrorMessage("Invalid rx delay, expects (1-15)");
                return false;
            }

            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}
