#include "CmdNetworkJoinStatus.h"

CmdNetworkJoinStatus::CmdNetworkJoinStatus(mDot* dot, mts::MTSSerial& serial) :
    Command(dot, "Network Join Status", "AT+NJS", "0: Not joined, 1: Joined"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdNetworkJoinStatus::action(std::vector<std::string> args)
{
    if (_dot->getVerbose())
        _serial.writef("%s: ", name());

    _serial.writef("%u\r\n", _dot->getNetworkJoinStatus());

    return 0;
}

