#include "CmdDeviceId.h"
#include <algorithm>

CmdDeviceId::CmdDeviceId(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Device ID", "AT+DI", "Device EUI-64 (MSB) (unique, set at factory) (8 bytes)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(hex:8)";
    _queryable = true;
}

uint32_t CmdDeviceId::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());
        _serial.writef("%s\r\n", mts::Text::bin2hexString(_dot->getDeviceId(), "-").c_str());
    }

    return 0;
}

bool CmdDeviceId::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    setErrorMessage("Invalid arguments");
    return false;
}
