#include "mbed.h"
#include "mDot.h"
#include "CommandTerminal.h"
#include "ATSerial.h"
#include "ATSerialFlowControl.h"

#define SERIAL_BUFFER_SIZE 1024

mts::ATSerial debug(USBTX, USBRX);

int main()
{
    debug.baud(115200);

    mDot* dot = mDot::getInstance();

    // Seed the RNG
    srand(dot->getRadioRandom());

    mts::ATSerial* serial;

    if (true)//(dot->getFlowControl())
        serial = new mts::ATSerialFlowControl(XBEE_DOUT, XBEE_DIN, XBEE_RTS, XBEE_CTS, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
    else
        serial = new mts::ATSerial(XBEE_DOUT, XBEE_DIN, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);

    debug.baud(dot->getDebugBaud());
    serial->baud(dot->getBaud());

    CommandTerminal term(*serial, dot);

    term.start();
}
