#include "CmdWakeTimeout.h"

CmdWakeTimeout::CmdWakeTimeout(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Wake Timeout", "AT+WTO", "Read serial data until timeout (milliseconds)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-65000) ms";
    _queryable = true;
}

uint32_t CmdWakeTimeout::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getWakeTimeout());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int timeout;
        sscanf(args[1].c_str(), "%d", &timeout);

        if ((code = _dot->setWakeTimeout(timeout)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdWakeTimeout::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int timeout;
        if (sscanf(args[1].c_str(), "%d", &timeout) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (timeout < 0 || timeout > 65000) {
            setErrorMessage("Invalid timeout, expects (0-65000) ms");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
