#include "CmdTxChannel.h"

CmdTxChannel::CmdTxChannel(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Tx Channels", "AT+TXCH", "List Tx channel frequencies for sub-band"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "<INDEX>,<FREQUENCY>,<DR_RANGE>";
    _queryable = true;
}

uint32_t CmdTxChannel::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        std::vector<uint32_t> channels = _dot->getChannels();

        if (_dot->getFrequencyBand() == mDot::FB_868) {
            for (int i = 0; i < 16; i++) {
                _serial.writef("%d: %d 125k\r\n", i, channels[i]);
            }
            _serial.writef("D: %d 125k\r\n", channels[8]);

        } else {

            for (int i = 0; i < 8; i++) {
                _serial.writef("%d: %d 125k\r\n", i, channels[i]);
            }

            _serial.writef("U: %d 500k\r\n", channels[8]);
            _serial.writef("D: %d 500k\r\n", channels[9]);
        }
    }

    if (args.size() == 4) {
        int index;
        int frequency;
        int datarateRange;

        sscanf(args[1].c_str(), "%d", &index);
        sscanf(args[2].c_str(), "%d", &frequency);
        sscanf(args[3].c_str(), "%02x", &datarateRange);

        _dot->addChannel(index, frequency, datarateRange);
    }

    return 0;
}

bool CmdTxChannel::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 4) {

        int index;
        int frequency;
        int datarateRange;

        sscanf(args[1].c_str(), "%d", &index);
        sscanf(args[2].c_str(), "%d", &frequency);
        sscanf(args[3].c_str(), "%02x", &datarateRange);

        if (_dot->getFrequencyBand() == mDot::FB_868) {
            if (index < 3 || index > 15) {
                setErrorMessage("Invalid index, expects (3-15)");
                return false;
            }

            if (frequency != 0 && (frequency < 863000000 || frequency > 870000000)) {
                setErrorMessage("Invalid frequency, expects (863000000-870000000)");
                return false;
            }
        } else {
            setErrorMessage("US915 Channels cannot be changed, use AT+FSB to limit");
            return false;
        }

        return true;
    } else {
        setErrorMessage("Invalid arguments");
        return false;
    }

}
