#include "CmdStartUpMode.h"

CmdStartUpMode::CmdStartUpMode(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Start Up Mode", "AT+SMODE", "0: AT command mode, 1: Serial data mode"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdStartUpMode::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%u\r\n", _dot->getStartUpMode());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint8_t mode;

        mode = (args[1] == "1") ? mDot::SERIAL_MODE : mDot::COMMAND_MODE;

        if ((code = _dot->setStartUpMode(mode)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdStartUpMode::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        if (args[1] != "1" && args[1] != "0") {
            setErrorMessage("Invalid parameter, expects (0: Command, 1: Serial Data)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
