#include "CmdSerialClearOnError.h"

CmdSerialClearOnError::CmdSerialClearOnError(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Clear On Error", "AT+SDCE", "Serial clear on error if enabled data that cannot be sent will be discarded"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0:off,1:on)";
    _queryable = true;
}

uint32_t CmdSerialClearOnError::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Serial Clear On Error: ");

        _serial.writef("%d\r\n", _dot->getSerialClearOnError());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        bool enable = (args[1] == "1");

        if ((code = _dot->setSerialClearOnError(enable)) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());
            return 1;
        }
    }

    return 0;
}

bool CmdSerialClearOnError::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        if (args[1] != "1" && args[1] != "0") {
            setErrorMessage("Invalid parameter, expects (0: off, 1: on)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
