#include "CmdRepeat.h"

CmdRepeat::CmdRepeat(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Packet Repeats", "AT+REP", "Configure number of times to repeat a packet"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-15)";
    _queryable = true;
}

uint32_t CmdRepeat::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Packet Repeats: ");

        _serial.writef("%u\r\n", _dot->getRepeat());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int repeat;
        sscanf(args[1].c_str(), "%d", &repeat);

        if ((code = _dot->setRepeat(repeat)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdRepeat::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int repeat;
        if (sscanf(args[1].c_str(), "%d", &repeat) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (repeat < 0 || repeat > 15)
        {
            setErrorMessage("Invalid repeats, expects (0-15)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
