#include "CmdReceiveContinuous.h"
#include "CommandTerminal.h"

CmdReceiveContinuous::CmdReceiveContinuous(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Receive Continuous", "AT+RECVC", "Continuously receive and display packets. (escape sequence: +++)"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "out: (string:242) or (hex:242)";
}

uint32_t CmdReceiveContinuous::action(std::vector<std::string> args) {
    std::vector<uint8_t> data;

    std::string escape_buffer;
    char ch;

    while (true) {

        _dot->openRxWindow(0);

        osDelay(1000);

        if (_dot->recv(data) == mDot::MDOT_OK) {
            if (_dot->getVerbose())
                _serial.writef("Packet data:\r\n");
            _serial.writef("%s\r\n", CommandTerminal::formatPacketData(data, _dot->getRxOutput()).c_str());

            data.clear();
        }

        while (_serial.readable()) {
            _serial.read(&ch, 1);
            escape_buffer += ch;
            if (escape_buffer == CommandTerminal::escape_sequence)
                return 0;

            osDelay(50);
        }

        escape_buffer.clear();
    }

    return 0;
}

bool CmdReceiveContinuous::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    setErrorMessage("Invalid arguments");
    return false;
}
