#include "CmdPing.h"

CmdPing::CmdPing(mDot* dot, mts::MTSSerial& serial) : Command(dot, "Send Ping", "AT+PING", "Sends ping and displays the servers received rssi and snr"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(-140-0),(-20.0-20.0)";
}

uint32_t CmdPing::action(std::vector<std::string> args)
{
    mDot::ping_response response;
    response = _dot->ping();
    if (response.status != mDot::MDOT_OK) {
        std::string error = mDot::getReturnCodeString(response.status);

        if (response.status != mDot::MDOT_NOT_JOINED)
            error +=  + " - " + _dot->getLastError();

        setErrorMessage(_dot->getLastError());;
        return 1;
    }

    _serial.writef("%d,%d.%d\r\n", response.rssi, response.snr / 10, abs(response.snr) % 10);

    return 0;
}

