#include "CmdLogLevel.h"

CmdLogLevel::CmdLogLevel(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Debug Log Level", "AT+LOG", "Enable/disable debug logging. (0: off, 1:Fatal - 6:Trace)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-6)";
    _queryable = true;
}

uint32_t CmdLogLevel::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Log Level: ");

        _serial.writef("%u\r\n", _dot->getLogLevel());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int level;
        sscanf(args[1].c_str(), "%d", &level);

        if ((code = _dot->setLogLevel(level)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdLogLevel::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int level;
        if (sscanf(args[1].c_str(), "%d", &level) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (level < 0 || level > 6) {
            setErrorMessage("Invalid level, expects (0-6)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
