#include "CmdJoinRequest.h"
#include "CommandTerminal.h"

CmdJoinRequest::CmdJoinRequest(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Join Network", "AT+JOIN", "Join network, provide argument of '1' to force join (acquire network address and session keys)"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(force:1)";
}

uint32_t CmdJoinRequest::action(std::vector<std::string> args) {
    int32_t code;
    std::string buf;

    if (args.size() > 1 && args[1] == "1")
        _dot->resetNetworkSession();

    if (_dot->getJoinMode() == 0) {
        _serial.writef("Join not necessary for Manual Join Mode\r\n");
        return 0;
    }

    code = _dot->joinNetworkOnce();

    if (code == mDot::MDOT_OK) {
        _serial.writef("Successfully joined network\r\n");
        return 0;
    } else {
        std::string error = mDot::getReturnCodeString(code)  + " - " + _dot->getLastError();
        setErrorMessage(_dot->getLastError());;
    }

    return 1;
}

bool CmdJoinRequest::verify(std::vector<std::string> args) {
    if (args.size() == 1 || (args.size() == 2 && args[1] == "1"))
        return true;

    setErrorMessage("Invalid arguments");
    return false;
}
