#include "CmdJoinByteOrder.h"

CmdJoinByteOrder::CmdJoinByteOrder(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Join Byte Order", "AT+JBO", "Send EUI's in join request with configured byte ordering (0:LSB,1:MSB)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0:LSB,1:MSB)";
    _queryable = true;
}

uint32_t CmdJoinByteOrder::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Join Byte Order: ");

        _serial.writef("%d\r\n", _dot->getJoinByteOrder());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        mDot::JoinByteOrder order = mDot::LSB;

        if (args[1] == "1")
            order = mDot::MSB;

        if ((code = _dot->setJoinByteOrder(order)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdJoinByteOrder::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        if (args[1] != "0" && args[1] != "1") {
            setErrorMessage("Invalid argument");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
