#include "CmdDownlinkCounter.h"

CmdDownlinkCounter::CmdDownlinkCounter(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Downlink Counter", "AT+DLC", "Get or set the downlink counter"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-4294967295)";
    _queryable = true;
}

uint32_t CmdDownlinkCounter::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Downlink Counter: ");

        _serial.writef("%u\r\n", _dot->getDownLinkCounter());
    } else if (args.size() == 2) {
        int32_t code;
        uint32_t count;
        sscanf(args[1].c_str(), "%lu", &count);

        if ((code = _dot->setDownLinkCounter(count)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }
    return 0;
}

bool CmdDownlinkCounter::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        uint32_t count;
        if (sscanf(args[1].c_str(), "%lu", &count) == 1) {
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}

