/*
 * CmdAppPort.cpp
 *
 *  Created on: Nov 4, 2015
 *      Author: jreiss
 */

#include "CmdAppPort.h"

CmdAppPort::CmdAppPort(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "App Port", "AT+AP", "Port used for application data (1 - 223)"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1-223)";
    _queryable = true;
}

CmdAppPort::~CmdAppPort()
{
    // TODO Auto-generated destructor stub
}

uint32_t CmdAppPort::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("App Port: ");

        _serial.writef("%u\r\n", _dot->getAppPort());
    } else if (args.size() == 2) {
        int32_t code;
        int appPort;
        sscanf(args[1].c_str(), "%d", &appPort);

        if ((code = _dot->setAppPort(appPort)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }
    return 0;
}

bool CmdAppPort::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        int appPort;
        if (sscanf(args[1].c_str(), "%d", &appPort) == 1) {
            if (appPort > 223 || appPort < 1) {
                setErrorMessage("Invalid app port, expects (1-223)");
                return false;
            }
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}
