#include "mbed.h"

DigitalOut led1(LED1);

InterruptIn greenButton(BUTTON1);
InterruptIn redButton(BUTTON2);
InterruptIn beep1Button(BUTTON3);
InterruptIn beep3Button(BUTTON4);

Serial cidron(p9, p10);  // tx, rx

uint8_t const GREEN[] = { 0xFF, 0x53, 0x00, 0x15, 0x00, 0x02, 0x69, 0x00, 0x00, 0x02, 0x0A, 0x00, 0x02, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15 };
uint8_t const RED[] = { 0xFF, 0x53, 0x00, 0x15, 0x00, 0x02, 0x69, 0x00, 0x00, 0x02, 0x0A, 0x00, 0x01, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16 };
uint8_t const BUZZER_1_BEEP[] = { 0xFF, 0x53, 0x00, 0x0C, 0x00, 0x01, 0x6A, 0x00, 0x02, 0x01, 0x01, 0x01, 0x31 }; 
uint8_t const BUZZER_3_BEEP[] = { 0xFF, 0x53, 0x00, 0x0C, 0x00, 0x01, 0x6A, 0x00, 0x02, 0x01, 0x01, 0x03, 0x2F };


void write(Serial & serial, uint8_t const *data, uint16_t length) {
    for (uint16_t i=0; i<length; i++) {
        serial.putc(data[i]);
    }
}

void greenButtonReleased(void){
    write(cidron, GREEN, sizeof(GREEN));
}

void redButtonReleased(void){
    write(cidron, RED, sizeof(RED));
}

void beep1ButtonReleased(void){
    write(cidron, BUZZER_1_BEEP, sizeof(BUZZER_1_BEEP));
}

void beep3ButtonReleased(void){
    write(cidron, BUZZER_3_BEEP, sizeof(BUZZER_3_BEEP));
}

int main() {
    cidron.baud(9600);
    
    greenButton.rise(greenButtonReleased);
    redButton.rise(redButtonReleased);
    beep1Button.rise(beep1ButtonReleased);
    beep3Button.rise(beep3ButtonReleased);
    
    while(1) {
        led1 = !led1;
        wait(1);
    }
}