#include "mbed.h"
#include "MDM.h"

//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      NULL
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.de/search?q=APN+list */
#define APN         "gprs.swisscom.ch"
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 
//---------------------------

int main(void)
{
    int ret;
    char buf[2048] = "";
    //give time to module for powering up (ms)
    wait_ms(1000);
    // Create the modem object
    MDMSerial mdm;
    mdm.set_flow_control(SerialBase::RTSCTS, MDMRTS, MDMCTS);
    wait(5);
    //mdm.setDebug(4); // enable this for debugging issues
    // initialize the modem 
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = mdm.init(SIMPIN, &devStatus);
    mdm.dumpDevStatus(&devStatus);
    if (mdmOk) {
        // wait until we are connected
        mdmOk = mdm.registerNet(&netStatus);
        mdm.dumpNetStatus(&netStatus);
    }
    if (mdmOk)
    {
        // join the internet connection 
        MDMParser::IP ip = mdm.join(APN,USERNAME,PASSWORD);
        if (ip != NOIP)
        {
            mdm.dumpIp(ip);
            
            int httpProfile = mdm.httpFindProfile();  //get the HTTP profile identifier
            if (httpProfile >= 0)
            {
                printf("Make an HTTP and HTTPS GET Request\r\n");
                if(mdm.httpResetProfile(httpProfile))
                {
                    if (mdm.httpSetPar(httpProfile,MDMParser::HTTP_SERVER_NAME,"api.bibo-siemens.com"))
                    {
                        if (mdm.httpSetPar(httpProfile,MDMParser::HTTP_SECURE,"1"))  //HTTP Secure option enabled
                        {
                            mdm.httpSetPar(httpProfile,MDMParser::HTTP_USER_NAME,"bibo-gateway");
                            mdm.httpSetPar(httpProfile,MDMParser::HTTP_PASSWORD,"bibo-gateway");
                            mdm.httpSetPar(httpProfile,MDMParser::HTTP_AUTH_TYPE,"1");
                            //mdm.httpSetPar(httpProfile,MDMParser::HTTP_SERVER_PORT,"443");
        
                            ret = mdm.httpCommand(httpProfile,MDMParser::HTTP_POST_DATA,"/v1/oauth/token?grant_type=client_credentials",
                                                                                                    "post","\n",4,NULL,buf,sizeof(buf));
                            if(ret > 0)
                                printf("HTTPS Post: %s", buf);                                                                        
                        } else {
                            printf("Abnormal condition during the set of HTTP secure option\r\n");
                        }
                        
                    } else {
                        printf("Abnormal condition during the set of the HTTP server name\r\n");
                    }
                } else {
                    printf("Abnormal condition during the reset of HTTP profile %d\r\n", httpProfile);
                }
            }
        }
    }
}