#include "mbed.h"


#include "C12832.h"
#include "LPC17xx.h"
#include "AnalogIn.h"
#include "FreeRTOS.h"
#include "task.h"
#include "LM75B.h"
#include "semphr.h"
#include "MMA7660.h"

#define LED1_GPIO  18
#define LED2_GPIO  20
#define LED3_GPIO  21
#define LED4_GPIO  23

#define LED_GPIO   LED1_GPIO


// LED Config
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// CAN Config
CAN can(p9, p10);
char temp = 0;
typedef union can_union {
    float fl;
    char bytes[4];
} data2send;

// Accelerometer
MMA7660 MMA(p28, p27);
DigitalOut connectionLed(LED1);
//PwmOut Zaxis_p(LED2);
//PwmOut Zaxis_n(LED3);

// Temperature sensor config
LM75B tmp(p28,p27);

//LCD configs
C12832 lcd(p5, p7, p6, p8, p11);

// File System Config
//MSCFileSystem fs("fs");

// Potenciometer Config
AnalogIn pot1(p19);
float pot = 0;

// Queue
xQueueHandle MyQueue;

typedef enum {
    INT,
    FLOAT,
    CHAR
} DATA_TYPE;

typedef struct queueData {
    DATA_TYPE type;
    void* pointer;
    int id;
} queueData;


// Semaphores
xSemaphoreHandle xMutexLCD;
xSemaphoreHandle xMutexI2C;

void init_hardware()
{
    /* set system tick for 1ms interrupt */
    SystemCoreClockUpdate();
}

void blink_led1_task(void *pvParameters)
{
    while(1) {
        led1 = !led1;
        vTaskDelay(1000/portTICK_RATE_MS);
    }
}

/*
void blink_led2_task(void *pvParameters)
{
    while(1) {
        led2 = !led2;
        vTaskDelay(500/portTICK_RATE_MS);
    }
}
*/

void can_send(void *pvParameters)
{
    int err;
    data2send data;
    queueData msg;
    for(;;) {
        xQueueReceive(MyQueue,&msg,portMAX_DELAY);
        //ATENÇÃO:Na leitura dos sensores apenas enviar os dados quando houver uma variação significativa, e.g. a temp variar 1ºC

        if(msg.type==FLOAT || msg.type==INT) {
            data.fl=*(float *)msg.pointer;
            can.write(CANMessage(msg.id, &data.bytes[0], 5));
        } else if(msg.type==CHAR)
            can.write(CANMessage(msg.id, (char *)msg.pointer, 2));
        if(!err) {
            led4=1;//error led
            xSemaphoreTake(xMutexLCD,portMAX_DELAY);
            lcd.locate(1,1);    // row 1, col 1
            lcd.printf("Message sent: ERROR");
            xSemaphoreGive(xMutexLCD);
        }
        led2 = !led2;
        /* if(can.write(CANMessage(1337, &data.bytes[0], 5))) {
             xSemaphoreTake(xMutexLCD,portMAX_DELAY);
                 lcd.locate(1,1);    // row 1, col 1
                 lcd.printf("Message sent: %f\n", data.fl);
             xSemaphoreGive(xMutexLCD);
             led2 = !led2;
         } */
    }

}

/*
void can_recv(void *pvParameters){
    CANMessage msg;
    //lcd.cls();
    for(;;){
        if(can2.read(msg)) {
            xSemaphoreTake(xMutexLCD,portMAX_DELAY);
            lcd.locate(1,10);    // row 10, col 1
            lcd.printf("Message received: %d\n", msg.data[0]);
            xSemaphoreGive(xMutexLCD);
            led2 = !led2;
        }

        vTaskDelay(200/portTICK_RATE_MS);
    }

}
*/

void acc_read (void *pvParameters)
{
    float acc[3];
    queueData msg_acc;
    int aux[3];
    //if (MMA.testConnection())
    //    led3 = !led3;

    while(1) {

        xSemaphoreTake(xMutexI2C,portMAX_DELAY);
        MMA.readData(acc);
        xSemaphoreGive(xMutexI2C);

        aux[0]=acc[0];
        aux[1]=acc[1];
        aux[2]=acc[2];
        msg_acc.type=INT;
        msg_acc.id=1337;
        msg_acc.pointer=(void *)&aux[0];

        xQueueSend(MyQueue,&msg_acc,10);
        /*xSemaphoreTake(xMutexLCD,portMAX_DELAY);
            lcd.locate(1,18);    // row 18, col 1
            lcd.printf("X-Y-Z: %2.2f %2.2f %2.2f", acc[0], acc[1], acc[2]);
        xSemaphoreGive(xMutexLCD);*/
    }

}

void readPot(void *pvParameters)
{
    queueData msg_pot;
    float *aux;
    while(1) {
        msg_pot.type=FLOAT;
        msg_pot.id=1337;
        *aux=pot1.read()*10;
        msg_pot.pointer=(void *)aux;
        xQueueSend(MyQueue,&msg_pot,10);
        vTaskDelay(10/portTICK_RATE_MS);
    }
}


int main(void)
{
    xTaskHandle blink_led1_task_handle = NULL;
    xTaskHandle can_send_handle = NULL;
    xTaskHandle can_recv_handle = NULL;
    xTaskHandle acc_recv_handle = NULL;
    xTaskHandle readPot_handle = NULL;

    xMutexLCD = xSemaphoreCreateMutex();
    xMutexI2C = xSemaphoreCreateMutex();
    MyQueue = xQueueCreate( 20, sizeof(queueData) );
    if(MyQueue == NULL) led4=1;//error code


    can.frequency(1000000);

    int task_error;

    /* initialize hardware */
    init_hardware();

    // create task to heartbeat LED
    task_error = xTaskCreate(blink_led1_task, "heartbeat", 2*configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY+1, &blink_led1_task_handle);
    if(task_error == errCOULD_NOT_ALLOCATE_REQUIRED_MEMORY) {
        led4=1;
    }

    // create task to send through CAN
    task_error = xTaskCreate(can_send, "CAN Send", 4*configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY+2, &can_send_handle);
    if(task_error == errCOULD_NOT_ALLOCATE_REQUIRED_MEMORY) {
        led4=1;
    }

    //create task to receive through CAN
    //xTaskCreate(can_recv, "CAN Recv", 2*configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY+2, &can_recv_handle);

    //create task to read accelerometer
    task_error = xTaskCreate(acc_read, "ACC Read", 2*configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY+1, &acc_recv_handle);
    if(task_error == errCOULD_NOT_ALLOCATE_REQUIRED_MEMORY) {
        led4=1;
    }

    //create task to write value of pot to usb
    task_error = xTaskCreate(readPot, "Read Pot", 2*configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY+1, &readPot_handle);
    if(task_error == errCOULD_NOT_ALLOCATE_REQUIRED_MEMORY) {
        led4=1;
    }



    /* Start the scheduler. */
    vTaskStartScheduler();

    /* should never reach here! */
    for(;;);
}