/*
 * An example showing how to use the CANnucleo library:
 *
 * Two affordable (less than $3 on ebay) STM32F103C8T6 boards (20kB SRAM, 64kB Flash),
 * (see [https://developer.mbed.org/users/hudakz/code/STM32F103C8T6_Hello/] for more details)
 * are connected to the same CAN bus via transceivers (MCP2551 or TJA1040, or etc.).
 * CAN transceivers are not part of NUCLEO boards, therefore must be added by you.
 * Remember also that CAN bus (even a short one) must be terminated with 120 Ohm resitors at both ends.
 *
 * For more details see the wiki page <https://developer.mbed.org/users/hudakz/code/CANnucleo_Hello/>
 *
 * NOTE: If you'd like to use the official NUCLEO boards comment out line 22
 *
 * The same code is used for both NUCLEO boards, but:
 *      For board #1 compile the example without any change.
 *      For board #2 comment out line 23 before compiling
 *
 * Once the binaries have been downloaded to the boards reset board #1.
 *
 */

//#define TARGET_STM32F103C8T6  1     // uncomment this line when using STM32F103C8T6 boards!
//#define BOARD1                1     // comment out this line when compiling for board #2


#define start_charge_msg "\x22\x80\x24\x01"
#define stop_charge_msg "\x22\x80\x24\x02"
#define charger_startup_msg "\x0\xB\x0\x0\x0\x0\x0\xB"    // charger writes this during startup
#define change_charger_can_bitrate_1Mbs "\x22\xDA\x20\x01\x04"

const unsigned int RX_ID = 0x100;
const unsigned int TX_ID = 0x101;

#include "CANnucleo.h"
#include "mbed.h"

/*
 * To avaoid name collision with the CAN and CANMessage classes built into the mbed library
 * the CANnucleo's CAN and CANMessage classes have been moved into the CANnucleo namespace.
 * Remember to qualify them with the CANnucleo namespace.
 */
CANnucleo::CAN          can(PA_11, PA_12);  // CAN Rx pin name, CAN Tx pin name
CANnucleo::CANMessage   rxMsg;
CANnucleo::CANMessage   txMsg;
CANnucleo::CANMessage   throttle_txMsg;


DigitalOut              led(PA_5);
DigitalOut              controller_key_switch(PA_6); // SS_Rel

Timer                   timer;
int                     counter = 0;
volatile bool           msgAvailable = false;
volatile bool           to_send = false;

/**
 * @brief   'CAN receive-complete' interrup handler.
 * @note    Called on arrival of new CAN message.
 *          Keep it as short as possible.
 * @param
 * @retval
 */
void onMsgReceived()
{
    msgAvailable = true;
}

/**
 * @brief   Main
 * @note
 * @param
 * @retval
 */
bool to_charge = 0;
bool charge = 0;
void led_error()
{

    led = !led;
    wait(0.1);
    led=!led;
    wait(0.1);
    led = !led;
    wait(0.1);
    led = !led;
    wait(0.1);
    led = !led;

}
int build_message(unsigned char * badjoras, const char * command)
{
    char *src;
    strcpy(src,command);
    strncpy((char *) badjoras,src,sizeof(command)-1);
    return (sizeof(command)-1);
}

void flip()
{
    to_send=1;                // append first data item
    to_charge=1;
    //controller_key_switch = !controller_key_switch;
    led = !led;
    charge = !charge;
}

bool controller = 0;//flag for turning on controller_key_switch
Ticker flipper;
void change_can_bitrate(){
    to_send= 1;
}
InterruptIn button(PC_13);

int main()

{
    can.frequency(125000);                     // set bit rate to 1Mbps
    can.attach(&onMsgReceived);                 // attach 'CAN receive-complete' interrupt handler
    flipper.attach(&change_can_bitrate, 5);           //heartbeat
    button.rise(&flip);
    led=0;
    printf("badjoras\n");

    while(true) {

        if(msgAvailable) {
            msgAvailable = false;               // reset flag for next use
            int len = can.read(rxMsg);
            printf("Id: %x ", rxMsg.id);
            for(int i = 0; i<len; i++) {
                printf("%x,", rxMsg.data[i]);
            }
            printf("\n\r");
            /*
            rxMsg >> controller;
                            led = controller;
                            controller_key_switch = controller;*/
            if(rxMsg.id == 0x28B) {
                if (memcmp(rxMsg.data,charger_startup_msg,8)==0) {
                    printf(" this is the message\n\r");
                    txMsg.clear();                      // clear Tx message storage
                    txMsg.id = 0x60B;
                    build_message(txMsg.data,stop_charge_msg);
                    txMsg.len = 4;
                    to_send = 1;
                }
            }
        }
        if(to_send) {
            to_send = 0;
            if(to_charge) {
                to_charge = 0;
                if(charge) {
                    txMsg.clear();                      // clear Tx message storage
                    txMsg.id = 0x60B;
                    build_message(txMsg.data,start_charge_msg);
                    txMsg.len = 4;
                } else {
                    txMsg.clear();                      // clear Tx message storage
                    txMsg.id = 0x60B;
                    build_message(txMsg.data,stop_charge_msg);
                    txMsg.len = 4;
                }

            } else {
                txMsg.clear();
                txMsg.id = 0x60B;
                build_message(txMsg.data, change_charger_can_bitrate_1Mbs);
                txMsg.len = 8;
            }
            if(!can.write(txMsg)) {
                led_error();
            } else {
                printf("sent message: ID: %x DATA: %x %x %x %x %x %x %x %x\n\r",txMsg.id,txMsg.data[0],txMsg.data[1],txMsg.data[2],txMsg.data[3],txMsg.data[4],txMsg.data[5],txMsg.data[6],txMsg.data[7]);
            }
        }
    }
}



