#include "mbed.h"

DigitalOut USER_LED(PA_9);

DigitalOut RTR_LED(PC_10);

DigitalOut CELL_TEMP_LED(PA_15);
DigitalOut HVS_LED(PA_10);



/*
         __A__
        |     |
        F     B
        |__G__|
        |     |
        E     C
        |__D__| .DP

*/
DigitalOut segs_enable_1(PB_14);
DigitalOut segs_enable_2(PB_13);
DigitalOut segs_enable_3(PB_12);
DigitalOut A(PB_10);
DigitalOut B(PB_1);
DigitalOut C(PC_5);
DigitalOut D(PA_7);
DigitalOut E(PA_6);
DigitalOut F(PB_2);
DigitalOut G(PB_0);
DigitalOut DP(PC_4);
void seg_number(int number)
{
    switch (number) {
        case 0:
            A = 0;
            B = 0;
            C= 0;
            D=0;
            E=0;
            F=0;
            G=1;
            DP=1;
            break;
        case 1:
            A=1;
            B=0;
            C=0;
            D=1;
            E=1;
            F=1;
            G=1;
            DP=1;
            break;
        case 2:
            A=0;
            B=0;
            C=1;
            D=0;
            E=0;
            F=1;
            G=0;
            DP=1;
            break;
        case 3:
            A=0;
            B=0;
            C=0;
            D=0;
            E=1;
            F=1;
            G=0;
            DP=1;
            break;
        case 4:
            A=1;
            B=0;
            C=0;
            D=1;
            E=1;
            F=0;
            G=0;
            DP=1;
            break;
        case 5:
            A=0;
            B=1;
            C=0;
            D=0;
            E=1;
            F=0;
            G=0;
            DP=1;
            break;
        case 6:
            A=0;
            B=1;
            C=0;
            D=0;
            E=0;
            F=0;
            G=0;
            DP=1;
            break;
        case 7:
            A=0;
            B=0;
            C=0;
            D=1;
            E=1;
            F=1;
            G=1;
            DP=1;
            break;
        case 8:
            A=0;
            B=0;
            C=0;
            D=0;
            E=0;
            F=0;
            G=0;
            DP=1;
            break;
        case 9:
            A=0;
            B=0;
            C=0;
            D=1;
            E=1;
            F=0;
            G=0;
            DP=1;
            break;
        default:
            A=1;
            B=1;
            C=1;
            D=1;
            E=1;
            F=1;
            G=1;
            DP=1;
    }
}

Ticker printer;
char position=0;
float number = 0;
int hundreds=0;
int decs = 0;
int units = 0;
void print()
{

    switch (position) {
        case 0:
            segs_enable_1 = 0;
            segs_enable_2=1;
            segs_enable_3 = 1;
            hundreds = number/100;
            seg_number(hundreds);
            position++;
            break;
        case 1:
            segs_enable_1 = 1;
            segs_enable_2 = 0;
            segs_enable_3 = 1;
            decs = number/10;
            decs = decs%10;
            seg_number(decs);
            position++;
            break;
        case 2:
            segs_enable_1 = 1;
            segs_enable_2 = 1;
            segs_enable_3 = 0;
            units = (int)number%10;
            seg_number(units);
            position = 0;
            break;
    }
}
    

Ticker incrementer;
void inc()
{
    number++;
    USER_LED = !USER_LED;
   
}

int main()
{
    USER_LED = 1;// LED is ON
    RTR_LED = 0;
    CELL_TEMP_LED = 0;
    HVS_LED = 1; 
    printf("badjoras\r\n");
    incrementer.attach(&inc,1);
    printer.attach(&print,0.01);
     
  
    while(1) {
        
        
    }
}
