/*
 * An example showing how to use the CANnucleo library:
 *
 * Two affordable (less than $3 on ebay) STM32F103C8T6 boards (20kB SRAM, 64kB Flash),
 * (see [https://developer.mbed.org/users/hudakz/code/STM32F103C8T6_Hello/] for more details)
 * are connected to the same CAN bus via transceivers (MCP2551 or TJA1040, or etc.).
 * CAN transceivers are not part of NUCLEO boards, therefore must be added by you.
 * Remember also that CAN bus (even a short one) must be terminated with 120 Ohm resitors at both ends.
 *
 * For more details see the wiki page <https://developer.mbed.org/users/hudakz/code/CANnucleo_Hello/>
 *
 * NOTE: If you'd like to use the official NUCLEO boards comment out line 22
 *
 * The same code is used for both NUCLEO boards, but:
 *      For board #1 compile the example without any change.
 *      For board #2 comment out line 23 before compiling
 *
 * Once the binaries have been downloaded to the boards reset board #1.
 *
 */

//#define TARGET_STM32F103C8T6  1     // uncomment this line when using STM32F103C8T6 boards!
//#define BOARD1                1     // comment out this line when compiling for board #2



const unsigned int RX_ID = 0x100;
const unsigned int TX_ID = 0x101;

#include "CANnucleo.h"
#include "mbed.h"

/*
 * To avaoid name collision with the CAN and CANMessage classes built into the mbed library
 * the CANnucleo's CAN and CANMessage classes have been moved into the CANnucleo namespace.
 * Remember to qualify them with the CANnucleo namespace.
 */
CANnucleo::CAN          can(PA_11, PA_12);  // CAN Rx pin name, CAN Tx pin name
CANnucleo::CANMessage   rxMsg;
CANnucleo::CANMessage   txMsg;
CANnucleo::CANMessage   throttle_txMsg;


DigitalOut              led(PA_5);

Timer                   timer;
int                     counter = 0;
volatile bool           msgAvailable = false;
volatile bool           to_send = false;

/**
 * @brief   'CAN receive-complete' interrup handler.
 * @note    Called on arrival of new CAN message.
 *          Keep it as short as possible.
 * @param
 * @retval
 */
void onMsgReceived()
{
    msgAvailable = true;
}

/**
 * @brief   Main
 * @note
 * @param
 * @retval
 */

bool key_switch = 0;

void flip()
{
    key_switch = !key_switch;
    led = key_switch;

    to_send=1;
    //printf("controller switch\r\n");



    // to_send = 1;
}

Ticker flipper;

typedef union can_union {
    int i[2];
    char bytes[8];
    float f[2];
} data;

int main()

{
    can.frequency(1000000);                     // set bit rate to 1Mbps
    can.attach(&onMsgReceived);                 // attach 'CAN receive-complete' interrupt handler
    flipper.attach(&flip, 30);                 // turn on or off
    led=key_switch;
    timer.start();  // start timer

    printf("started\r\n");
    while(true) {

        if(msgAvailable) {
            static int counter = 0;
            data data;
            int len = can.read(rxMsg);
            data.bytes[0] = rxMsg.data[0];
            data.bytes[1] = rxMsg.data[1];
            data.bytes[2] = rxMsg.data[2];
            data.bytes[3] = rxMsg.data[3];
            msgAvailable = false;               // reset flag for next use
            printf(" Id: %d, data: %f, counter : %d\n", rxMsg.id, data.f[0],rxMsg.data[4]);

            /*
            printf("\r\nreceived message ID: \t%d\n\r", rxMsg.id);
            for(int i=0; i<len; i++) {
                printf("\t%x",rxMsg.data[i]);
            }*/
            printf("\r\n");
            counter++;
            if(counter == 12) {

                counter = 0;
                printf("\r\n""""""""""""""""""""""""""""""""""""""""""""""""\r\n");
            }
            // Filtering performed by software:
        }
        if(to_send) {
            to_send = 0;
            txMsg.clear();
            txMsg.id = 10;
            txMsg << key_switch;
            if(can.write(txMsg)) {
                printf("sent message\r\n");
            } else {
                static char count = 0;
                count++;
                printf("transmission error\n\r overflow: %x\n\r", count);
                if(count == 3) {
                    count = 0;
                    NVIC_SystemReset();
                    // attach 'CAN receive-complete' interrupt handler

                }

            }
        }
    }
}



