#include "CANnucleo.h"
#include "mbed.h"
#include "LTC68041.h"



uint8_t const TOTAL_IC = 1;//!<number of ICs in the daisy chain

uint8_t rx_cfg[TOTAL_IC][8];
uint8_t tx_cfg[TOTAL_IC][6];
uint16_t aux_codes[TOTAL_IC][6];
uint16_t cell_codes[TOTAL_IC][12];
volatile bool           msgAvailable = false;
volatile bool           to_send = false;
CANnucleo::CAN          can(PA_11, PA_12);  // CAN Rx pin name, CAN Tx pin name
CANnucleo::CANMessage   rxMsg;
CANnucleo::CANMessage   txMsg;
DigitalOut              led(PA_5);
/*!***********************************
\brief Initializes the configuration array
**************************************/
void init_cfg()
{
    for (int i = 0; i<TOTAL_IC; i++) {
        tx_cfg[i][0] = 0xFE;
        tx_cfg[i][1] = 0x00 ;
        tx_cfg[i][2] = 0x00 ;
        tx_cfg[i][3] = 0x00 ;
        tx_cfg[i][4] = 0x00 ;
        tx_cfg[i][5] = 0x00 ;
    }
}
void serial_print_hex(uint8_t data)
{
    if (data< 16) {
        printf("0");
        printf("%x",(uint8_t)data);
    } else
        printf("%x",(uint8_t)data);
}
void print_config()
{
    int cfg_pec;
    printf("Written Configuration:\n\r ");
    for (int current_ic = 0; current_ic<TOTAL_IC; current_ic++) {
        printf(" IC ");
        printf("%d", current_ic+1);
        printf(": ");
        printf("0x");
        serial_print_hex(tx_cfg[current_ic][0]);
        printf(", 0x");
        serial_print_hex(tx_cfg[current_ic][1]);
        printf(", 0x");
        serial_print_hex(tx_cfg[current_ic][2]);
        printf(", 0x");
        serial_print_hex(tx_cfg[current_ic][3]);
        printf(", 0x");
        serial_print_hex(tx_cfg[current_ic][4]);
        printf(", 0x");
        serial_print_hex(tx_cfg[current_ic][5]);
        printf(", Calculated PEC: 0x");
        cfg_pec = pec15_calc(6,&tx_cfg[current_ic][0]);
        serial_print_hex((uint8_t)(cfg_pec>>8));
        printf(", 0x");
        serial_print_hex((uint8_t)(cfg_pec));
    }
    printf("\n\r");
}

void print_rxconfig()
{
    printf("Received Configuration ");
    for (int current_ic=0; current_ic<TOTAL_IC; current_ic++) {
        printf(" IC ");
        printf("%d " ,current_ic+1);
        printf(": 0x");
        serial_print_hex(rx_cfg[current_ic][0]);
        printf(", 0x");
        serial_print_hex(rx_cfg[current_ic][1]);
        printf(", 0x");
        serial_print_hex(rx_cfg[current_ic][2]);
        printf(", 0x");
        serial_print_hex(rx_cfg[current_ic][3]);
        printf(", 0x");
        serial_print_hex(rx_cfg[current_ic][4]);
        printf(", 0x");
        serial_print_hex(rx_cfg[current_ic][5]);
        printf(", Received PEC: 0x");
        serial_print_hex(rx_cfg[current_ic][6]);
        printf(", 0x");
        serial_print_hex(rx_cfg[current_ic][7]);
    }
}
int err;
void print_cells2()
{

    for (int current_ic = 0 ; current_ic < TOTAL_IC; current_ic++) {

        for (int i=0; i<12; i++) {
            printf(" C");
            printf("%d",i+1);
            printf(":");
            printf("%f", cell_codes[current_ic][i]*0.0001);
            printf(",");
        }

    }
}
void pec_error()
{
    for(int i = 0; i<5; i++) {
        led = 1;
        wait(0.2);
        led=0;
        wait(0.2);
    }
}
char cells_left=0;
Ticker ticker;
Ticker sender;

typedef union can_union {
    int i[2];
    char bytes[8];
    float f[2];
} data;

void message_trigger()
{
    if(cells_left < 1) {
        sender.detach();
    } else {


        to_send = 1;
    }

}

void check_charging_voltage()
{
    wakeup_idle();
    __disable_irq();
    LTC6804_adcv();
    __enable_irq();
    wait_ms(10);
    wakeup_idle();
    __enable_irq();
    err = LTC6804_rdcv(0, TOTAL_IC,cell_codes);
    __disable_irq();
    if (err == -1) {
        pec_error();
    }
    for (int current_ic = 0 ; current_ic < TOTAL_IC; current_ic++) {
        for (int i=0; i<12; i++) {
            if(cell_codes[current_ic][i]*0.0001  > 3.85) {
                switch (i) {
                    case 0:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x01 ;
                    case 1:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x02 ;
                    case 2:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x04 ;
                    case 3:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x08 ;
                    case 4:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x10 ;
                    case 5:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x20 ;
                    case 6:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x40 ;
                    case 7:
                        tx_cfg[0][4] = tx_cfg[0][4] | 0x80;
                    case 8:
                        tx_cfg[0][5] = tx_cfg[0][5] | 0x01;
                    case 9:
                        tx_cfg[0][5] = tx_cfg[0][5] | 0x10;
                }
            }
        }
    }
    //print_cells2();
    __disable_irq();
    LTC6804_wrcfg(TOTAL_IC,tx_cfg);
    __enable_irq();
}



void check_discharging_voltage()
{
    wakeup_idle();
    LTC6804_adcv();

    wait_ms(10);
    wakeup_idle();
    err = LTC6804_rdcv(0, TOTAL_IC,cell_codes);
    if (err == -1) {
        pec_error();
    }/*
    for (int current_ic = 0 ; current_ic < TOTAL_IC; current_ic++) {
        for (int i=0; i<11; i++) {
            //printf("%f\t", cell_codes[current_ic][i]*0.0001);
            if(cell_codes[current_ic][i]*0.0001  < 2.7) {
                txMsg.clear();
                txMsg.id = 1;
                printf("%f\t", cell_codes[current_ic][i]*0.0001);

                txMsg << cell_codes[current_ic][i]*0.0001;
                can.write(txMsg);
                wait(0.1);
            }
        }
    }*/
    //print_cells2();
    cells_left = 12;

//print_cells2();
    LTC6804_wrcfg(TOTAL_IC,tx_cfg);
}

void onMsgReceived()
{
    msgAvailable = true;
}



bool to_charge_or_not_to_charge=false;           // false = discharge
bool charging = false;
bool discharging = false;
void monitor()
{
    led = !led;
    if(to_charge_or_not_to_charge) {
        charging = 1;
        discharging = 0;
    } else {
        discharging = 1;
        charging = 0;
    }
}


int main()
{
        data data;

    //printf("starting\n\r");
    led =1;
    wait(1);
    pec_error();
    discharging = 1;

    ticker.attach(&monitor, 5);
    LTC6804_initialize();
    init_cfg();
//write configuration
    wakeup_sleep();
    __disable_irq();    // Disable Interrupts
    LTC6804_wrcfg(TOTAL_IC,tx_cfg);
    __enable_irq();
    wait(1);
//read configuration: may differ from written config
    wakeup_sleep();
    __disable_irq();
    err = LTC6804_rdcfg(TOTAL_IC,rx_cfg);
    __enable_irq();
    if (err == -1) {
        pec_error();
    }
    wait(0.5);

    wakeup_idle();
    __disable_irq();
    LTC6804_adcv();
    __enable_irq();
    wait_ms(10);
    wakeup_idle();
    __disable_irq();
    err = LTC6804_rdcv(0, TOTAL_IC,cell_codes);
    __enable_irq();
    if (err == -1) {
        pec_error();
    }
    can.frequency(1000000);                     // set bit rate to 1Mbps
    can.attach(&onMsgReceived);
    //print_cells2();
    while(1) {
        if(charging) {
            charging = 0;
            check_charging_voltage();

        }
        if(discharging) {
            discharging = 0;
            check_discharging_voltage();
            sender.attach(&message_trigger,0.1);
        }
        if(to_send) {
            
                
            to_send=0;
            txMsg.clear();
            txMsg.id = 10;
            txMsg.len = 5;
            data.f[0] = cell_codes[0][cells_left-1]*0.0001;
            txMsg.data[0] = data.bytes[0];
            txMsg.data[1] = data.bytes[1];
            txMsg.data[2] = data.bytes[2];
            txMsg.data[3] = data.bytes[3];
            txMsg.data[4] = cells_left;
            cells_left--;
            if(!(can.write(txMsg))) {
                pec_error();
                cells_left++;
                //to_send=1;
            }

        }
    }

}
