#ifndef ROBOTICS_RFID_READER_H
#define ROBOTICS_RFID_READER_H


/**
 * @file robotics_rfid_reader.h
 * @author sepro
 * @version 1.0
 * @class RoboticsRfidReader
 * @date 31/01/2021
 */

#include "mbed.h"

/**
 * Example
 * @code
 * #define ID_BADGE "1 7 221 87 161"
 * RoboticsRfidReader myRfid(D1, D0);
 *
 * int main() {
 * unsigned char buffer[30];
 * bool lineRead;
 * printf("RFID TEST \r\n");
 *
 * while (true) {
 *   lineRead = myRfid.rfidRead(buffer);
 *   if (lineRead) {
 *     printf("buffer : %s", buffer);
 *     printf("\r\n");
 *     if (strstr((char *)tampon, ID_BADGE))) {
 *       printf(" OK \r\n");
 *     } else {
 *       printf(" NOK \r\n");
 *     }
 *   }
 * }
 * }
 * @endcode
 */

class RoboticsRfidReader {

public:
  /**
   * @brief RoboticsRfid constructor
   * @param Tx : Tx pin
   * @param Rx : Rx Pin
   */
  RoboticsRfidReader(PinName Tx, PinName Rx);

  /**
   * @brief Non blockin readin on serial. '\n' for End Of Line
   * @param tampon  : reception buffer
   * @return true if the read is complete, false otherwise
   *         tampon will contain the string (in a char* )
   *
   */
  bool rfidRead(unsigned char *tampon);

private:
  UnbufferedSerial _rfid;
  unsigned char _c;
};

#endif
