#include "robotics_rfid_reader.h"

/**
 * @file robotics_rfid_reader.cpp
 * @brief  RFID Robotics reader class
 * @author sepro
 * @version 1.0
 * @class RoboticsRfidReader
 * @date 31/01/2021
 */

RoboticsRfidReader::RoboticsRfidReader(PinName Tx, PinName Rx)
    : _rfid(Tx, Rx)

{
  _rfid.baud(9600);
  _rfid.format(8, SerialBase::None, 1);
}


bool RoboticsRfidReader::rfidRead(unsigned char *tampon) {
  static int iBuffer = 0;

  if (_rfid.readable()) {
    _rfid.read(&_c,1);
    tampon[iBuffer++] = _c;
    if (_c == '\n') {
      tampon[iBuffer] = 0;
      iBuffer = 0;
      return true;
    }
  }
  return false;
}
