# Librairie Robotics_RFID_Reader

## Import library

```shell
mbed add http://os.mbed.com/users/sepro/code/Grove-RFID-Reader/
```





# Class documentation

### public members

**Constructor RoboticsRfid** 

```c++
RoboticsRfidReader(PinName Tx, PinName Rx);
```

**Non blockin line reading on serial. '\n' for End Of Line.**

```c++
bool rfidRead(unsigned char *tampon)
```

### Private attributes

```
UnbufferedSerial **_rfid**
```

```
unsigned char **_c**
```



### Description

 Example

```c++
#define ID_BADGE "1 7 221 87 161"
RoboticsRfidReader myRfid(D1, D0);

int main() {
	unsigned char buffer[30];
	bool lineRead;
	while (true) {
  		lineRead = myRfid.rfidRead(buffer);
  		if (lineRead) {
			printf("buffer : %s", buffer);
 			printf("\r\n");
		if (strstr((char *)tampon, ID_BADGE))) {
 			printf("OK \r\n");
		} else {
  			printf("NOK \r\n");
 		}
  	}
}
```

