#include "mbed.h"
#include "Server.h"
#include "EthernetInterface.h"

Server::Server(char* sourceAddress)
{
    eth = new EthernetInterface();
    eth->init(sourceAddress,"255.255.255.0","");
    eth->connect(500);

    server = new TCPSocketServer();
    
    server->bind(4000);
    server->listen();
    
    socket = new TCPSocketConnection();
    socket->set_blocking(false, 10);
    server->set_blocking(false, 10);
    

}
void Server::printStatus()
{
    printf("IP Address is %s\n\r", eth->getIPAddress());
}
int Server::connect(char* destinationAddr)
{
    socket->set_blocking(false, 10);
    if(socket->connect(destinationAddr, 4000) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n\r", destinationAddr, 4000);
        return 0;
    }
    return 1;
}
void Server::send(char* data)
{
    socket->send_all(data, 256);
    printf("Send data");//,data);
    socket->close();
}
int Server::read(char* buffer)
{
    resetSocket();
    server->accept(*socket);

    int connectionRead = 0;
    if(socket->is_connected()) {

        printf("connection incoming from: %s \n\r",socket->get_address());
        while(true) {
            int n = socket->receive(buffer, 256);
            if (n <= 0) break;
        }
        printf("-------------\n\r");
        printf("\n reciving:  %s\n\r",buffer);
        printf("\n\r");
        connectionRead = 1;
    }
    socket->close();
    return connectionRead;
}

int Server::close()
{
    socket->close();
    return 1;
}
Server::~Server()
{
    eth->disconnect();
}
void Server::resetSocket()
{
    socket->close();
    delete socket;
    socket = new TCPSocketConnection();
    socket->set_blocking(false, 10);
}