#include "mbed.h"
#include "Server.h"
#include "Frame.h"
#include "Tune.h"
#include "Display.h"
#include "Temperature.h"
#include "Potentiometer.h"

InterruptIn buttonSend(p8);
bool Send;
void SendISR()
{
    Send=1;
}

InterruptIn buttonDestinationIpUp(p7);
int IpDestination=10;
bool BoolIpDestination;
char destIp[14];
void DestinationIpUp()
{
    BoolIpDestination=1;
}

//PWM-signaal gegenereerd op basis van de potentiometerwaarde
PwmOut PWMout(p22);
int main()
{
    buttonSend.rise(&SendISR);  // attach the address of the flip function to the rising edge
    buttonDestinationIpUp.rise(&DestinationIpUp);  // attach the address of the flip function to the rising edge

    char buf[256];
    Frame dataFrame;
    Server server("192.168.0.107");
    server.printStatus();
    Display display;
    display.setText("Seppe's MBED");
    Tune tune;
    Temperature temp;
    Potentiometer potentiometer;

    while(1) {
        if(server.read(buf)) {
            if(!dataFrame.Decode(buf))
                printf("Frame CRC Error \n\r");
            if((dataFrame.getIdDestinationMbed()==7) && (!dataFrame.CheckMyID(7))) {
                printf("Voor mij\n\r");
                PWMout=potentiometer.getPotentiometer();
                PWMout.period(0.010);// set PWM period to 10 ms
                tune.play(dataFrame.getTune());
                display.setText("Temp: %d C",dataFrame.getTemperature());
                dataFrame.setIdDestinationMbed(IpDestination);
                dataFrame.setTemperature(temp.getTemperature());
                dataFrame.setPWMDutycycle(potentiometer.getPotentiometer());
                dataFrame.setTune(dataFrame.getTune()+1);
                dataFrame.AddID(7);
                dataFrame.Encode(buf);
                server.connect(destIp);
                server.send(buf);
            }
          /*  if() {
                server.connect(destIp);
                server.send(buf);
            }*/
        }
        if(BoolIpDestination) {
            if(IpDestination!=15)
                IpDestination++;
            else
                IpDestination=1;
            sprintf(destIp,"192.168.0.1%02i",IpDestination);
            display.setText("IP:192.168.0.1%02i",IpDestination);
            BoolIpDestination=0;
            wait(0.5);
        }
        if(Send) {
            dataFrame.setIdDestinationMbed(IpDestination);
            dataFrame.setTemperature(temp.getTemperature());
            dataFrame.setPWMDutycycle(potentiometer.getPotentiometer());
            tune.play(1);
            dataFrame.setTune(2);
            dataFrame.AddID(7);
            //char testIDs[]= {0x08,0x09,0x0A};
            //dataFrame->setLengthIDs(3);
            //dataFrame->setIDs(testIDs);
            dataFrame.Encode(buf);

            server.connect(destIp);
            server.send(buf);
            Send=0;
            wait(0.5);
        }
    }
}