#include "mbed.h"
#include "EthernetInterface.h"


DigitalOut led(LED1);

int main() //Werkt samen met Aaron Degroote
{
    EthernetInterface eth;
    eth.set_network("192.168.0.45","255.255.255.0","192.168.0.1");
    eth.connect();
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    TCPServer srv(&eth);  
    srv.bind(4000);
    srv.listen();
    
    while(true){
        TCPSocket client;
        SocketAddress clientaddress;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &clientaddress);
        
        printf("Accepted %s:%d\n\r", clientaddress.get_ip_address(), 
                    clientaddress.get_port());
                    
        client.send(buffer, 256);
        
        
        
        char buffer2[64];
        int count2 = client.recv(buffer2, sizeof buffer2);
        
        uint16_t TempClient = ((buffer2[1] & 0xFF) << 8 ) | (buffer2[2] & 0xFF);
        TempClient =  TempClient >> 5;
        
            
        if (TempClient & (1 << 10)){
            
            TempClient |= 0xFC00;
            
            }

        //temperatuur naar een normaal leesbaar getal omzetten in °C
         float temperatuur = TempClient * 0.125;
        
        printf("received: %d\r\n", count2);
        printf("PWM Waarde PotentioMeter: %d\r\n", buffer2[0]);
        printf("Temperatuurswaarde LM75B: %d\r\n", temperatuur);
        
        client.close();
        
    }
}