
#ifndef LED_WS2812_H
#define LED_WS2812_H

#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"

/*
#define ZERO_HIGH  250.0
#define ZERO_LOW  1000.0
#define ONE_HIGH  1000.0
#define ONE_LOW   250.0
*/
#define ZERO_HIGH  200.0
#define ZERO_LOW  800.0
#define ONE_HIGH  800.0
#define ONE_LOW   200.0

 typedef enum _LED_COLORS {
        BLUE        = 0x0000FF,
        LIGHTBLUE   = 0x00FFF6,
        RED         = 0xFF0000,
        ORANGE      = 0xFF3500,
        GREEN       = 0X00FF00,
        BLACK       = 0X000000,
        WHITE       = 0XFFFFFF,
        PURPLE      = 0XFF00FF,
        PINK        = 0XFF84A3,
        YELLOW      = 0XFFFF00,
        DARK_YELLOW = 0X555500,
        DEFAULT     = 0x000000
    } LED_COLORS;
    
class LED_WS2812
{
public:
    LED_WS2812(PinName _PinOut,  int _nbLeds);
    ~LED_WS2812();
    void SetColor(LED_COLORS _color, int position);
    void SetColor(unsigned int _color, int position);
    void SetColor(unsigned int _color);
    void SetColor(LED_COLORS _color);
    void ResetColor();
    void SetIntensity(float perCent);
 
    void InsertColor(unsigned int _color);
    void InsertColor(unsigned int _color, float brightness);
    void InsertColorNtimes(int N, unsigned int _color, float brightness);  
    void InsertColorNtimes(int N, unsigned int _color);

    void InsertColor(LED_COLORS _color);
    void InsertColor(LED_COLORS _color, float brightness);
    void InsertColorNtimes(int N, LED_COLORS _color, float brightness);  
    void InsertColorNtimes(int N, LED_COLORS _color);

    void StartRotation(float interval); // interval in s
    void StopRotation();  // 
    void Rotate(); // One Rotation
    
    void StartBlink(float interval); // interval in s
    void StopBlink();  //
    void Blink(); // One Rotation
      
private:
    void __writeBuf(int z);
    void __insert2buf();
    void __insertColor(unsigned int _color, int _intensity);

    WS2812 *ws;
    int nbLeds;
    PixelArray *pxArray;
    int nbInsert;
    PixelArray *pxInsert;
    Ticker  LEDSystemTick;    // System Callback for Rotation
    Ticker  LEDBlinkSystemTick;    // System Callback for Rotation
    bool rotationState;
   bool blinkState;
    int rotationPosition;
    bool blinkONOFF; // ON = true, OFF = false
    int intensity;
};

#endif