
#ifndef BOT_AUXILIARIES_H
#define BOT_AUXILIARIES_H

#include "mbed.h"
#include "LED_WS2812.h"
#include <string> 

// Put the LED names in the order they are chained up 
enum LED_Nr{ ledAvG, ledAvD, ledArD, ledArG, NumLEDs };

// *****************************************************************
// Handle all the LEDs with some general function wrappers functions
// *****************************************************************

/** Control 4 LEDs around the Car: front / rear, left / right
 *
 * Example:
 * @code
 * // --- Define the PIN where the LED band is connected -----
 * LEDs_Car ledBand(PB_5,4);
 * Setup rainbow colors for the ledBand
 * ledBand.LEDsRainbow();
 * Rotate the colors for the ledBand
 * ledBand.StartRotation(0.6) ;
 * Turn off the LEDs:
 * ledBand.LEDsOff();
 * @endcode
 */


class LEDs_Car: public LED_WS2812
{
  public:
   /** Create a Car-LED object to control the four LEDs around the car
     *
     *  @param PinName Pin Name through wich the LEDs are controlled
     *  @param _nbLeds Number of LEDs actually implemented, defaults to 4
     */
    LEDs_Car(PinName _PinOut,  int _nbLeds):LED_WS2812(_PinOut, _nbLeds) {  };
    
    void LEDsOff( void );
    void LEDsRainbow( void );
    void LEDNrCol(LED_Nr aNr, int parameter) ;
    void LEDsRainbowMove( double speed );
    void LEDClignote(LED_Nr aNr, int OnOff);
    int ColNr2Color( char ColNr);

    // *****************************************************************
    // Handle all the LEDs specifically with the LED Position definitions
    // *****************************************************************
    
    void LEDFront(int ColNr) ;
    void LEDRear(int ColNr) ;
    void LEDCligR(int speed);
    void LEDCligL(int speed);
    void LEDAnim(int speed);
}; // class LEDs_Car

#endif