// *****************************************************************
// Handle all the LEDs with some general function wrappers functions
// *****************************************************************
#include "LEDs_Car.h"

// Added a lookup function from a color number to a color, used by Creabot
int LEDs_Car::ColNr2Color( char ColNr)
{  switch (ColNr) {
    case 0: return BLACK;
    case 1: return WHITE;
    case 2: return RED;
    case 3: return GREEN;
    case 4: return BLUE;
    case 5: return PURPLE;
    default: return BLACK;
    }
}

void LEDs_Car::LEDsOff( void ) {
    StopRotation();
    StopBlink() ;
    for (int lNr=0; lNr<NumLEDs; lNr++) 
        { SetColor(BLACK,lNr); } 
}

void LEDs_Car::LEDsRainbow( void )
{ for (int Nr=0; Nr<NumLEDs; Nr++) 
    { SetColor(ColNr2Color(Nr + 1),Nr); }   
}

void LEDs_Car::LEDNrCol(LED_Nr aNr, int parameter) 
{   
  SetColor( ColNr2Color( aNr ), aNr);
}

void LEDs_Car::LEDsRainbowMove( double speed )
{   LEDsRainbow( );
    StartRotation(0.3);
}

void LEDs_Car::LEDClignote(LED_Nr aNr, int OnOff) {
    if (OnOff == 1) {
        SetColor( ORANGE, aNr);
        StartBlink(0.5) ;} 
    else { LEDsOff(); }
}

// *****************************************************************
// Handle all the LEDs specifically with the LED Position definitions
// *****************************************************************

void LEDs_Car::LEDFront(int ColNr) 
{   
  SetColor( ColNr2Color( ColNr ), ledAvD);
  SetColor( ColNr2Color( ColNr ), ledAvG);
}
  
void LEDs_Car::LEDRear(int ColNr) 
{   
  SetColor( ColNr2Color( ColNr ), ledArD);
  SetColor( ColNr2Color( ColNr ), ledArG);
}
  
void LEDs_Car::LEDCligR(int speed) {
    if ( (speed>0) && (speed<4) ) {
       SetColor(ORANGE, ledAvD) ;
       SetColor(ORANGE, ledArD) ;
       StartBlink(float(speed)/4) ;} 
    else { LEDsOff(); }
 }

void LEDs_Car::LEDCligL(int speed) {
    if ( (speed>0) && (speed<4) ) {
       SetColor(ORANGE, ledAvG) ;
       SetColor(ORANGE, ledArG) ;
       StartBlink(float(speed)/4) ;} 
    else { LEDsOff(); }
}

void LEDs_Car::LEDAnim(int speed) {
    if ( (speed>0) && (speed<4) ) 
        { LEDsRainbowMove(float(speed)/4); }
      else {  LEDsOff();  }
}

