
#ifndef CMD_Interpreter_H
#define CMD_Interpreter_H

#include "mbed.h"
#include <string> 

const int BuffLen = 512;

// define commands to be handled!
typedef void (*caseHandler)(int param);

typedef struct EXE_CMD_TYPE{
    char cmd;    // THe single command character
    char Npar;   // The number of parameters needed by the command, only for help text. All command Hanlders must have a Parameter
    caseHandler Handler; // Command Handlers
    string help;  // Help Text  for that command
    }EXE_CMD_TYPE;

// Define States of the interpreter
enum InterpretState { isStartNew, isLineFilling, isOverflow, isWaitNewLine};

typedef struct RD_CMD_TYPE {
    char Command;    // Holds the next read command character
    int  Parameter ; // Holds one int Parameter
    int  NumParam ;  // Indicates how many parameters where found
    } RD_CMD_TYPE;

// Uses a Ring buffer to buffer incomiing characters
// Uses a parsing function to extract lines containing a command each
class Interpreter{
  public: 
    // Interpreter Class Creation 
    Interpreter( void );
    void Reinit( void );
    void FillCommands(int aNumCommands, const EXE_CMD_TYPE *ACommands );
  public: // the writing mechanics
    void AddChar ( char aChar ); // Barebone function, assumes that checks havee been performed by writeBuf!
    void writeBuf( char c ) ; // High level method to add a Char to the buffer,
    char RingBuf[BuffLen];
    InterpretState MyState;// Indicates if buffer overflow, line ended etc. 
    int  WriteIndex   ;  // points to next index to write to
    int  BufAvail     ;  // indicates how much of the buffer is still available
    int  LinesComplete; // Indicates how many complete lines are available
    bool ProcessPresentCommands( void );
    RD_CMD_TYPE ParseCommand( void );
    bool executeCommand(RD_CMD_TYPE cmd);
    void PrtCmdHelp  ( Serial *aSerial ); // Display list of Commands
    // void GetLastMessage( string LastMsg); // not possible to implement at the moment
  public: // the reading mechanics
    int  ScanIndex;    // points to next index to read from to
    char actC     ;    // holds the actual character
  private:
    char GetAChar  ( void );
    void SkipBlanks( void );
    int  ReadAnInt ( void );
    char actPP     ( void );
    EXE_CMD_TYPE* AllCommands; // Defines an array of all commands to be filled by the user. 
    int NumCommands; // Holds the actual number of commands that are stored in the array
    /*
    char buff[100]; // Intermediate buffer to hold messages for datalogging
    string LastMessage;
    void DataLog( char *DebugMessage );
    void CmdInval( int param );  // Feedback that the command is invalid
    */
}; // class Interpreter

#endif // CMD_Interpreter_H