#include "mbed.h"
#include "MODSERIAL.h"
#include "Watchdog.h"
#include "ADS8568_ADC.h"
#include "Heater.h"
#include "FastPWM.h"

#include "math.h"
/*------------------------------------------------------------------------------
Codebase for T99004 Demo Control Board Rev A Firmware
Date: 10/07/2018
Author: AS7


------------------------------------------------------------------------------*/

#define ALL_CH 15               //value of convst bus to read all chanels simultaneosly


Watchdog wd;                    //instantiate watchdog class

MODSERIAL pc(PA_9, PA_10, 512); //mcu TX, RX, 512 byte TX and RX buffers

//ADC object inherits SPI, 
ADS8568_ADC adc(PB_15, PB_14, PB_13, PB_12, PC_15, PC_0, PC_1, PC_2, PC_3);

//SPI spi(PB_15, PB_14, PB_13);   // mosi, miso, sclk
I2C i2c(PB_7, PB_8);            //SDA, SCL

//indicator LEDs
DigitalOut hb_led(PC_13);       //Green
DigitalOut led_0(PC_4);         //Red
DigitalOut led_1(PC_5);         //Green

//User buttons
DigitalIn user_0(PB_0);
DigitalIn user_1(PB_1);

//ADC
//BusOut adc_convt(PC_0, PC_1, PC_2, PC_3);   //channel convert ch_A, ch_B, ch_C, ch_D
//DigitalOut adc_ncs(PB_12);                   //chip n_select
DigitalIn adc_busy(PA_8);                   //Busy interrupt sig
//DigitalOut adc_reset(PC_15);

/*ADC channels are connected as follows------------
CH_A0 = Heater 1 Current Sense
CH_A1 = Heater 1 Voltage Sense
CH_B0 = Heater 2 Current Sense
CH_B1 = Heater 2 Voltage Sense
CH_C0 = Photodiode Amp Out 1
CH_C1 = Photodiode Amp Out 2
CH_D0 = Photodiode Amp Out 3
CH_D1 = Photodiode Amp Out 4
---------------------------------------------------*/

//Heater Control
FastPWM drive_1(PC_9);
FastPWM drive_2(PC_8);
FastPWM guard_1(PC_7);
FastPWM guard_2(PC_6);
Timer timer;


//Global vars instatiation (to be moved to new places)
char buffer16[16];
float voltages[8];
int values[8];
int i = 0;
int log_count = 0;

float cur1 = 0;
float cur2 = 0;
float R1 = 0;
float R2 = 0;
float scale_factors[8];
float scale_factor = 13.273;
int drivetime_ms = 0;
int OSR = 1;
float R_avg = 0;

char outString[100];

const float h1_inter = 0.392;
const float h2_inter = 0.392;
const float h1_slope = 0.0019;
const float h2_slope = 0.0019;


Heater heater_1(0,1,&drive_1, &guard_1, h1_inter, h1_slope);
Heater heater_2(2,3,&drive_2, &guard_2, h2_inter, h2_slope);


int main()
{
    // Initialsation
    pc.baud(115200);        
    //led_1 = drive_1; //tie led 1 and heater 1 outputs together so LED shows while heater is on (initial debug purposes only)
    adc.init();                     //initialise ADC
    timer.start();                  //Start the timer   
    drivetime_ms = 50;
    
    //Initialise drive periods
    drive_1.prescaler(1);    
    guard_1.prescaler(1);
    drive_2.period_ticks(TICK_CYCLE);   
    guard_2.period_ticks(TICK_CYCLE);

    //while (user_1==0); //waits for a button press before starting the programme
    
    
    float ratio_guard = 21.0/82;
    int tic_main = 150;
    int tic_guard = floor(tic_main * ratio_guard);
    
    while(1){

        drive_2.pulsewidth_ticks(tic_main);
        guard_2.pulsewidth_ticks(tic_guard);
        wait(2);
        heater_2.output();  
        //pc.printf("%d, %f, %f\n",tic_guard,j,ratio_guard);

    }    
   
}
