
#include "WANOT.h"

/*
 *  Global variables declarations
 */
 
extern SuperSlotStates SuperSlotState;

extern Slave_Beacon_State Slave_Beacon_States;

volatile SlaveSetUpStates SlaveSetUpState = Rx_Init;
extern SlaveRegStates SlaveRegState;

volatile msgType messageType = msgRTS;
volatile msgType messageType2 = msgCTS;

extern RadioEvents_t RadioEvents;
extern SX1276MB1xAS Radio;

extern uint16_t BufferSize;
extern uint8_t Buffer[];

extern uint32_t LORA_Channels[NUMBER_OF_CHANNELS];

extern int16_t RssiValue;
extern int8_t SnrValue;

extern uint8_t TDMAChannel;
extern uint8_t SlaveLocalID;

void SetUp_OnTxDone(void)
{
    Radio.Rx(RX_TIMEOUT_VALUE);
    debug("SetUp_OnTxDone!!\n\r");

}

void SetUp_OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep();
    BufferSize = size;
    memcpy(Buffer, payload, BufferSize);
    RssiValue = rssi;
    SnrValue = snr;
    debug("SetUp_OnRxDone!!\n\r");

    switch (SlaveSetUpState) {
        case Wait_for_Beacon:
            if(Buffer[0] == BEACON_SYNCWORD) {
                SlaveSetUpState = Phy_CS;
                debug("Beacon Packet\n\r");
            } else {
                SlaveSetUpState = Rx_Init;
                debug("Beacon Mismatch\n\r");

            }
            break;

        case Virtual_CS:
            if ((messageType == Buffer[0]) || (messageType2 == Buffer[0])) {
                SlaveSetUpState = Channel_Busy;
                debug("Channel is Busy(CTS/RTS)!!\n\r");
            } else {
                SlaveSetUpState = Channel_Busy;
                debug("Channel is Busy(Invalid Packet)!!\n\r");
            }
            break;

        case Wait_for_CTS:
            messageType = msgCTS;
            if (messageType == Buffer[0]) {
                SlaveSetUpState = Send_JoinReq;
                debug("CTS Packet\n\r");
            } else {
                SlaveSetUpState = Rx_Init;
                debug("CTS Mismatch\n\r");
            }
            break;

        case Wait_for_JoinAccept:
            messageType = msgJoinAccept;
            if (messageType == Buffer[0]) {
                SlaveLocalID = Buffer[11];
                SlaveSetUpState = Send_ACK;
                debug("JoinAccept Packet\n\r");
            } else {
                SlaveSetUpState = Rx_Init;
                debug("JoinAccept Mismatch\n\r");
            }
            break;

        default:
            debug("Invalid Packet!!");
    }


}

void SetUp_OnTxTimeout(void)
{
    SlaveSetUpState = Rx_Init;
    debug("SetUp_OnTxTimeout!!\n\r");

}

void SetUp_OnRxTimeout(void)
{
    switch(SlaveSetUpState) {
        case Virtual_CS:
            SlaveSetUpState = Send_RTS;
            debug("Channel is Free!!\n\r");
            break;
        default:
            SlaveSetUpState = Rx_Init;
            debug("SetUp_OnRxTimeout!!\n\r");
    }
}

void SetUp_OnRxError(void)
{
    SlaveSetUpState = Rx_Init;

}

void SlaveSetUp()
{
    debug("Slave Set Up Phase Started...\n\r");
    
    // Initialize Radio driver
    RadioEvents.TxDone = SetUp_OnTxDone;
    RadioEvents.RxDone = SetUp_OnRxDone;
    RadioEvents.RxError = SetUp_OnRxError;
    RadioEvents.TxTimeout = SetUp_OnTxTimeout;
    RadioEvents.RxTimeout = SetUp_OnRxTimeout;
    Radio.Init(&RadioEvents);

    while ((SuperSlotState == SetUp_Phase) && (SlaveRegState == UnRegistered) && (Slave_Beacon_States == Beacon_Recieved)) {
        switch (SlaveSetUpState) {
            case Phy_CS:
                if(Radio.IsChannelFree(MODEM_LORA, SET_UP_FREQUENCY, RSSI_THRESHOLD))   {
                    uint16_t BackOffValue = MIN_BACK_OFF + /*rand()%*/RANDOM_BACK_OFF_WINDOW;
                    SlaveSetUpState = Virtual_CS;
                    Radio.Rx(BackOffValue);
                }   else    {
                    SlaveSetUpState = Channel_Busy;
                }
                break;


            case Virtual_CS:
                break;

            case Channel_Busy:
                debug("Channel Busy !!\n\r");
                wait_ms(MIN_BACK_OFF + RANDOM_BACK_OFF_WINDOW * rand());
                SlaveSetUpState = Wait_for_Beacon;
                break;

            case Send_RTS:
                messageType = msgRTS;
                Buffer[0] = messageType;
                Buffer[1] = SnrValue;
                Radio.Send(Buffer, BUFFER_SIZE_RTS);
                debug("Case of RTS Sent\n\r");
                SlaveSetUpState = Wait_for_CTS;
                break;

            case Send_JoinReq:
                messageType = msgJoinReq;
                Buffer[0] = messageType;
                Radio.Send(Buffer, BUFFER_SIZE_JoinReq);
                debug("Case of JoinRequest Sent\n\r");
                SlaveSetUpState = Wait_for_JoinAccept;
                break;

            case Send_ACK:
                messageType = msgAck;
                Buffer[0] = messageType;
                Radio.Send(Buffer, BUFFER_SIZE_Ack);
                debug("Registered\n\r");
                SlaveSetUpState = Rx_Init;
                SlaveRegState = Registered;
                debug("Slave Set Up Phase Finished...\n\r");
                return;

            case Rx_Init:
                Radio.Rx( RX_TIMEOUT_VALUE );
                SlaveSetUpState = Wait_for_Beacon;
                debug("Case of Rx_Init\n\r");
                break;
            case Wait_for_Beacon:
            case Wait_for_CTS:
            case Wait_for_JoinAccept:
                break;
            default:
                break;

        }

    }
}
