#include "WANOT.h"

/*
 *  Global variables declarations
 */
 
extern SuperSlotStates SuperSlotState;

volatile SlaveRegStates SlaveRegState = UnRegistered;  
volatile Slave_Beacon_State Slave_Beacon_States = Beacon_Wait; 

extern RadioEvents_t RadioEvents;
extern SX1276MB1xAS Radio;

extern uint16_t BufferSize;
extern uint8_t Buffer[];

extern int16_t RssiValue;
extern int8_t SnrValue;

extern uint32_t LORA_Channels[];

extern uint8_t TDMAChannel;

volatile uint8_t Beacon_New_Rx_Flag = 0;
volatile uint8_t Beacon_Counter = 0;

void Beacon_OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep();
    BufferSize = size;
    memcpy(Buffer, payload, BufferSize);
    RssiValue = rssi;
    SnrValue = snr;
    debug("Beacon_OnRxDone!!\n\r");

    Beacon_New_Rx_Flag = 0;

    if(Buffer[0] == SETUP_BEACON_SYNCWORD) {
        TDMAChannel = Buffer[1];
        debug("Beacon Recieved!!\n\r");
        Slave_Beacon_States = Beacon_Recieved;
    } else {
        debug("Beacon Mismatch\n\r");
    }
}

void Beacon_OnRxTimeout(void)
{
    Beacon_Counter++;
    Beacon_New_Rx_Flag = 0;
    debug("Beacon Not Found!!\n\r");
}


void SetUp_Beacon(void)
{
    debug("Beacon SetUP State!!\n\r");
    
    Beacon_New_Rx_Flag = 0;
    Beacon_Counter = 0;

    Slave_Beacon_States = Beacon_Wait;

    RadioEvents.RxDone = Beacon_OnRxDone;
    RadioEvents.RxTimeout = Beacon_OnRxTimeout;
    Radio.Init(&RadioEvents);

    Radio.SetChannel(SET_UP_FREQUENCY);

    Radio.SetTxConfig(MODEM_LORA, TX_OUTPUT_POWER, 0, SET_UP_LORA_BANDWIDTH,
                      SET_UP_LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                      LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, 2000000);

    Radio.SetRxConfig(MODEM_LORA, SET_UP_LORA_BANDWIDTH, SET_UP_LORA_SPREADING_FACTOR,
                      LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                      LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, true);

    while((SuperSlotState == SetUp_Beacon_Phase) && (Beacon_Counter != 8) && (Slave_Beacon_States != Beacon_Recieved)) {
        debug("Waiting for Beacon\n\r");
        Beacon_New_Rx_Flag = 1;
        Radio.Rx( RX_TIMEOUT_VALUE );
        while(Beacon_New_Rx_Flag == 1);
    }


    Radio.SetChannel(LORA_Channels[TDMAChannel]);

    Radio.SetTxConfig(MODEM_LORA, TX_OUTPUT_POWER, 0, SET_UP_LORA_BANDWIDTH,
                      SET_UP_LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                      LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, 2000000);

    Radio.SetRxConfig(MODEM_LORA, SET_UP_LORA_BANDWIDTH, SET_UP_LORA_SPREADING_FACTOR,
                      LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                      LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, true);


    debug("Finished Beacon State\n\r");
    //RTC Sleep for the rest of setup beacon
}
