#include "mbed.h"
#include "sx1276-hal.h"
#include "debug.h"
#include "radio.h"
#include "Serial.h"
#include "Timeout.h"

#include "SuperSlot.h"

#include "SlaveSetUp.h"
#include "SlaveBeacon.h"
#include "SlaveTDMA.h"

#include"GPS.h"

/*
 *  LoRa Default Params
 */

#define TX_OUTPUT_POWER                             10        // 14 dBm

#define LORA_CODINGRATE                             1         // [1: 4/5]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         5         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_FHSS_ENABLED                           false
#define LORA_NB_SYMB_HOP                            4
#define LORA_IQ_INVERSION_ON                        false

#define NUMBER_OF_CHANNELS                          8
#define RSSI_THRESHOLD                              -90

/*
 *  Set Up Phase Params
 */

#define SET_UP_LORA_SPREADING_FACTOR                7        // [SF7..SF12]
#define SET_UP_LORA_CRC_ENABLED                     false
#define SET_UP_LORA_BANDWIDTH                       0        // [0: 125 kHz,
#define SET_UP_FREQUENCY                            LORA_Channels[0]
#define MIN_BACK_OFF                                1000 //uS
#define RANDOM_BACK_OFF_WINDOW                      10000 //uS
#define BEACON_TIMEOUT_VALUE                        100000   // in us
#define TDMA_TIME_OUT_VALUE                         100000


/*
 *  Buffer Sizes
 */

#define RX_TIMEOUT_VALUE                            100000   // in us
#define BUFFER_SIZE                                 70        // Define the payload size here
#define BUFFER_SIZE_RTS                             2
#define BUFFER_SIZE_CTS                             2
#define BUFFER_SIZE_JoinReq                         6
#define BUFFER_SIZE_JoinAccept                      14
#define BUFFER_SIZE_Ack                             2
#define BUFFER_SIZE_Beacon                          1
#define BUFFER_SIZE_TDMA_DATA                       50

/*
 *  Beacons Synch Words
 */

#define SETUP_BEACON_SYNCWORD                       0x74
#define BEACON_SYNCWORD                             0x74

/*
 *  SuperSlot Phases Intervals
 */
 
 #define BEACON_SET_UP_INTERVAL                     1.2
 #define SET_UP_INTERVAL                            19.8
 #define TDMA_INTERVAL                              39