#include "WANOT.h"

/*
 *  Global variables declarations
 */

extern SuperSlotStates SuperSlotState;
extern SlaveRegStates SlaveRegState;

extern RadioEvents_t RadioEvents;
extern SX1276MB1xAS Radio;

extern uint16_t BufferSize;
extern uint8_t Buffer[];

extern uint32_t LORA_Channels[NUMBER_OF_CHANNELS];

extern int16_t RssiValue;
extern int8_t SnrValue;

extern uint8_t TDMAChannel;
extern uint8_t SlaveLocalID;

volatile SlaveTDMAStates SlaveTDMAState = TDMA_Wait_for_Beacon;
volatile TDMA_msgType TDMA_messageType = TDMA_msgRTS;


void TDMA_OnTxDone(void)
{
    Radio.Rx(RX_TIMEOUT_VALUE);
    debug("TDMA_OnTxDone!!\n\r");

}

void TDMA_OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep();
    BufferSize = size;
    memcpy(Buffer, payload, BufferSize);
    RssiValue = rssi;
    SnrValue = snr;
    debug("TDMA_OnRxDone!!\n\r");

    switch (SlaveTDMAState) {
        case TDMA_Wait_for_Beacon:

            if(Buffer[0] == SETUP_BEACON_SYNCWORD) {
                debug("Beacon Packet\n\r");
                if(Buffer[1] == SlaveLocalID)
                {
                    SlaveTDMAState = TDMA_Send_RTS;
                    debug("Slave Correct Slot \n\r");
                }   else    {
                    debug("Slave InCorrect Slot \n\r");
                    //SlaveTDMAState = TDMA_Finished;////////////////////////////////
                    SlaveTDMAState = TDMA_Wait_for_Beacon;
                }
            } else {
                debug("Beacon Mismatch\n\r");
                
                SlaveTDMAState = TDMA_Finished;
            }
            break;


        case TDMA_Wait_for_CTS:
            TDMA_messageType = TDMA_msgCTS;
            if (TDMA_messageType == Buffer[0]) {
                debug("CTS Packet\n\r");
                SlaveTDMAState = TDMA_Send_Data;
            } else {
                debug("Wait for CTS failed \n\r");
                
                SlaveTDMAState = TDMA_Finished;
            }
            break;

        case TDMA_Wait_for_Ack:
            TDMA_messageType = TDMA_msgAck;
            if (TDMA_messageType == Buffer[0]) {
                debug("Data Sent and Master Acked \n\r");
                SlaveTDMAState = TDMA_Wait_for_Beacon;
                
                SlaveTDMAState = TDMA_Finished;
            } else {
                debug("Master Ack Mismatch \n\r");
                
                SlaveTDMAState = TDMA_Finished;
            }
            break;

        default:
            debug("Invalid Packet!!");
            
            SlaveTDMAState = TDMA_Finished;
    }
    
}

void TDMA_OnTxTimeout(void)
{
    debug("TDMA_OnTxTimeout!!\n\r");
    
    SlaveTDMAState = TDMA_Finished;
}

void TDMA_OnRxTimeout(void)
{
    debug("TDMA_OnRxTimeout!!\n\r");
    
    SlaveTDMAState = TDMA_Finished;
}

void TDMA_OnRxError(void)
{
    debug("TDMA_OnRxError!!\n\r");
    
    SlaveTDMAState = TDMA_Finished;
}

void SlaveTDMA()
{
    
    debug("Slave TDMA Started...\n\r");
    
    SlaveTDMAState = TDMA_Wait_for_Beacon;

    // Initialize Radio driver
    RadioEvents.TxDone = TDMA_OnTxDone;
    RadioEvents.RxDone = TDMA_OnRxDone;
    RadioEvents.RxError = TDMA_OnRxError;
    RadioEvents.TxTimeout = TDMA_OnTxTimeout;
    RadioEvents.RxTimeout = TDMA_OnRxTimeout;
    Radio.Init(&RadioEvents);

    Radio.SetTxConfig(MODEM_LORA, TX_OUTPUT_POWER, 0, SET_UP_LORA_BANDWIDTH,
                      SET_UP_LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                      LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, 2000000);

    Radio.SetRxConfig(MODEM_LORA, SET_UP_LORA_BANDWIDTH, SET_UP_LORA_SPREADING_FACTOR,
                      LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                      LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, true);

    Radio.SetChannel(LORA_Channels[TDMAChannel]);
    Radio.Rx(RX_TIMEOUT_VALUE);


    while (SuperSlotState == TDMA_Phase) {
        
        switch (SlaveTDMAState) {

            case TDMA_Send_RTS:
                TDMA_messageType = TDMA_msgRTS;
                Buffer[0] = TDMA_messageType;
                Buffer[1] = SnrValue;
                Radio.Send(Buffer, BUFFER_SIZE_RTS);
                debug("Sending RTS\n\r");
                SlaveTDMAState = TDMA_Wait_for_CTS;
                break;

            case TDMA_Send_Data:
                TDMA_messageType = TDMA_msgData;
                Buffer[0] = TDMA_messageType;
                Radio.Send(Buffer, BUFFER_SIZE_TDMA_DATA);
                debug("Sending DATA\n\r");
                SlaveTDMAState = TDMA_Wait_for_Ack;
                break;
                
            case TDMA_Finished:
                debug("Slave TDMA Slot Finished...\n\r");
                return;


            case TDMA_Wait_for_Beacon:
            case TDMA_Wait_for_CTS:
            case TDMA_Wait_for_Ack:

                break;
            default:
                break;

        }

    }
}