#include "WANOT.h"

/*
 *  Global variables declarations
 */

extern SuperSlotStates SuperSlotState;

extern RadioEvents_t RadioEvents;
extern SX1276MB1xAS Radio;

extern uint16_t BufferSize;
extern uint8_t Buffer[];

extern int16_t RssiValue;
extern int8_t SnrValue;

extern uint32_t LORA_Channels[NUMBER_OF_CHANNELS];

extern uint8_t SlotNumber;
extern uint8_t TDMAChannel;

volatile MasterTDMAStates MasterTDMAState = TDMA_sendBeacon;
volatile TDMA_msgType TDMA_messageType = TDMA_msgRTS;
volatile uint8_t Beacon_Counter = 0;

static Timer timer;
static int begin, end;

void TDMA_OnTxDone(void)
{
    if( MasterTDMAState != TDMA_Wait_for_Data ){
        Radio.Rx(RX_TIMEOUT_VALUE);
        debug("TDMA OnTxDone!!\n\r");
    }   else    {
        Radio.Rx(4*RX_TIMEOUT_VALUE);
        debug("TDMA OnTxDone!!\n\r");
    }

}

void TDMA_OnRxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep();
    BufferSize = size;
    memcpy(Buffer, payload, BufferSize);
    RssiValue = rssi;
    SnrValue = snr;

    debug("OnRxDone!!\n\r SNR = %d , RSSI = %d\n\r",snr, rssi);

    switch (MasterTDMAState) {
        case TDMA_Wait_for_RTS:
            TDMA_messageType = TDMA_msgRTS;
            if (TDMA_messageType == Buffer[0]) {
                MasterTDMAState = TDMA_Send_CTS;
                debug("RTS Packet\n\r");
            } else {
                MasterTDMAState = TDMA_sendBeacon;
                debug("RTS Packet Mismatch\n\r");
            }
            break;

        case TDMA_Wait_for_Data:
            TDMA_messageType = TDMA_msgData;
            if (TDMA_messageType == Buffer[0]) {
                MasterTDMAState = TDMA_Send_Ack;
            } else {
                MasterTDMAState = TDMA_sendBeacon;
            }
            break;

        default:
            break;


    }


}

void TDMA_OnTxTimeout(void)
{

}

void TDMA_OnRxTimeout(void)
{
    MasterTDMAState = TDMA_sendBeacon;
    debug("OnRxTimeout!!\n\r");

}

void TDMA_OnRxError(void)
{
    MasterTDMAState = TDMA_sendBeacon;
}

void MasterTDMA(uint8_t SlaveLocalID)
{
    debug("Master TDMA Phase Started...\n\r");
    
    timer.start();
    begin = timer.read_us();
    
    MasterTDMAState = TDMA_sendBeacon;
    
    // Initialize Radio driver
    RadioEvents.TxDone = TDMA_OnTxDone;
    RadioEvents.RxDone = TDMA_OnRxDone;
    RadioEvents.RxError = TDMA_OnRxError;
    RadioEvents.TxTimeout = TDMA_OnTxTimeout;
    RadioEvents.RxTimeout = TDMA_OnRxTimeout;
    Radio.Init(&RadioEvents);

    Radio.SetChannel(LORA_Channels[TDMAChannel]);

    Radio.SetTxConfig(MODEM_LORA, TX_OUTPUT_POWER, 0, SET_UP_LORA_BANDWIDTH,
                      SET_UP_LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                      LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, 2000000);

    Radio.SetRxConfig(MODEM_LORA, SET_UP_LORA_BANDWIDTH, SET_UP_LORA_SPREADING_FACTOR,
                      LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                      LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, true);

    while (SuperSlotState ==  TDMA_Phase) {
        switch (MasterTDMAState) {
            case TDMA_sendBeacon:
                if (Beacon_Counter < 2) {
                    Beacon_Counter++;
                    Buffer[0] = SETUP_BEACON_SYNCWORD;
                    Buffer[1] = SlaveLocalID;
                    Radio.Send(Buffer, BUFFER_SIZE_RTS);
                    debug("TDMA_sendBeacon\n\r");
                    MasterTDMAState = TDMA_Wait_for_RTS;
                } else {
                    MasterTDMAState = TDMA_Slave_Not_Found;
                    Beacon_Counter = 0;
                }
                break;

            case TDMA_Send_CTS:
                TDMA_messageType = TDMA_msgCTS;
                Buffer[0] = TDMA_messageType;
                Buffer[1] = SnrValue;
                Radio.Send(Buffer, BUFFER_SIZE_CTS);
                debug("RTS Received\n\r");
                MasterTDMAState = TDMA_Wait_for_Data;
                break;

            case TDMA_Send_Ack:
                TDMA_messageType = TDMA_msgAck;
                Buffer[0] = TDMA_messageType;
                Radio.Send(Buffer, BUFFER_SIZE_JoinAccept);
                debug("Data Received\n\r");
                end = timer.read_us();
                debug("TDMA took : %f S\n\r", (end-begin+20000)/1000000.0);
                debug("Master TDMA Slot Finished...\n\r");
                return;

            case TDMA_Slave_Not_Found:
                debug("Case of Slave Not Found\n\r");
                Radio.Sleep();
                wait_us(TDMA_TIME_OUT_VALUE);
                MasterTDMAState = TDMA_sendBeacon;
                break;

            case TDMA_Wait_for_RTS:
            case TDMA_Wait_for_Data:
                break;
            default:
                break;

        }

    }
}