#include"WANOT.h"

/*
 *  Global variables declarations
 */

extern SuperSlotStates SuperSlotState; 

extern RadioEvents_t RadioEvents;
extern SX1276MB1xAS Radio;

extern uint16_t BufferSize;
extern uint8_t Buffer[];

extern int16_t RssiValue;
extern int8_t SnrValue;

extern uint32_t LORA_Channels[NUMBER_OF_CHANNELS];

extern uint8_t SlotNumber;
extern uint8_t TDMAChannel;


volatile uint8_t Beacon_Tx_Done = 0;
void SetUp_Beacon_OnTxDone(void)
{
    Beacon_Tx_Done = 1;
    debug("Beacon Tx Done!!\n\r");
}


void SetUp_Beacon(void)
{
    debug("Master Set Up Beacon Started...\n\r");
    
    Radio.SetTxConfig(MODEM_LORA, TX_OUTPUT_POWER, 0, SET_UP_LORA_BANDWIDTH,
                      SET_UP_LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                      LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, 2000000);

    Radio.SetRxConfig(MODEM_LORA, SET_UP_LORA_BANDWIDTH, SET_UP_LORA_SPREADING_FACTOR,
                      LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                      LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, true);
    Radio.SetChannel(SET_UP_FREQUENCY);

    Beacon_Tx_Done = 0;
    RadioEvents.TxDone = SetUp_Beacon_OnTxDone;
    Radio.Init(&RadioEvents);

    if (TDMAChannel != 0)
        Radio.Sleep();
    
    wait_us(TDMAChannel * BEACON_TIMEOUT_VALUE);

    Buffer[0] = SETUP_BEACON_SYNCWORD;
    Buffer[1] = TDMAChannel;

    Radio.Send(Buffer, BUFFER_SIZE_RTS);

    while(Beacon_Tx_Done != 1);

    debug("Beacon Sent\n\r");

    Radio.SetTxConfig(MODEM_LORA, TX_OUTPUT_POWER, 0, SET_UP_LORA_BANDWIDTH,
                      SET_UP_LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                      LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, 2000000);

    Radio.SetRxConfig(MODEM_LORA, SET_UP_LORA_BANDWIDTH, SET_UP_LORA_SPREADING_FACTOR,
                      LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                      LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                      SET_UP_LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                      LORA_IQ_INVERSION_ON, true);


    Radio.SetChannel(LORA_Channels[TDMAChannel]);
     
    debug("Master Set Up Beacon Done!!\n\r");
    //Sleep untill setup phase RTC
}